% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonCarousel.R
\name{argonCarousel}
\alias{argonCarousel}
\title{Create a carousel}
\usage{
argonCarousel(..., id, floating = FALSE, hover_lift = FALSE, width = 6)
}
\arguments{
\item{...}{Slot for \link{argonCarouselItem}.}

\item{id}{Carousel unique id.}

\item{floating}{Whether to apply a floating effect. FALSE by default.}

\item{hover_lift}{Whether to apply a lift effect on hover. FALSE by default.
Not compatible with floating. Only if card_mode is TRUE.}

\item{width}{Carousel width.}
}
\description{
Build an argon carousel
}
\examples{
if (interactive()) {
 library(argonR)
 argonCarousel(
  id = "carousel2",
  argonCarouselItem(
    src = "https://demos.creative-tim.com/argon-design-system/assets/img/theme/img-1-1200x1000.jpg",
    active = TRUE
  ),
  argonCarouselItem(
    src = "https://demos.creative-tim.com/argon-design-system/assets/img/theme/img-2-1200x1000.jpg",
    active = FALSE
  )
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
