% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_slice.R
\name{group_slice}
\alias{group_slice}
\title{Subset Data Frames by a Group Variable Using Their Positions}
\usage{
group_slice(
  data,
  group,
  n = 1,
  prop = NULL,
  position = "head",
  group_output = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble with at least 1 variable.}

\item{group}{A variable in \code{data} that will be used for groupings.}

\item{n, prop}{Supply either \code{n}, the number of groups, or \code{prop}, the proportion of groups to select. \code{n} must be a positive integer that is greater than or equal to 1. \code{prop} must be a positive numeric value that is greater than 0 and less than or equal to 1.

Default is \code{n} = 1.}

\item{position}{A character string of \code{"head"} or \code{"tail"}. Determines if the first group or last group in the data frame is selected where \code{"head"} will select the first group in the dataframe and \code{"tail"} will select the last group.}

\item{group_output}{A logical boolean \code{TRUE} or \code{FALSE}. If \code{TRUE}, returns a grouped tibble.

Default is \code{FALSE}}
}
\value{
A sliced dataframe
}
\description{
Subset Data Frames by a Group Variable Using Their Positions
}
\examples{
vec_coords <- 1:10
df_data <-
 data.frame(
   "x" = vec_coords,
   "y" = vec_coords,
   "group_col" = group_numbers(1:5) |> rep(each = 2)
 )

df_sliced_data_head <-
 df_data |>
 group_slice(group_col, n = 2, position = "head")

df_sliced_data_head

df_sliced_data_tail <-
 df_data |>
 group_slice(group_col, n = 2, position = "tail")

df_sliced_data_tail

df_sliced_data_prop <-
 df_data |>
 group_slice(group_col, prop = .80)

df_sliced_data_prop

}
