% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3D.R
\name{n_bound_connect_3D}
\alias{n_bound_connect_3D}
\title{N Bound Connect 3D}
\usage{
n_bound_connect_3D(alpha, delta = 0.05, r = 1, rmin = 0.01, bound = "cube")
}
\arguments{
\item{alpha}{radius of open balls around points}

\item{delta}{probability of isolated point}

\item{r}{radius of sphere, outer radius of shell, or length of cube side}

\item{rmin}{inner radius of shell}

\item{bound}{manifold from which points sampled. Options are sphere, shell, cube}
}
\value{
integer of minimum number of points needed
}
\description{
Function returns the minimum number of points to preserve the homology with
an open cover of radius alpha.
}
\examples{
# For a cube with probability 0.05 of isolated points
n_bound_connect_3D(0.2, 0.05,0.9)
# For a sphere with probability 0.01 of isolated points
n_bound_connect_3D(0.2, 0.01, 1, bound="sphere")
# For a shell with probability 0.1 isolated points.
n_bound_connect_3D(0.2, 0.1, 1, 0.25, bound="shell")
}
