% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanimp.R
\name{meanimp}
\alias{meanimp}
\title{Mean imputation for the survival time}
\usage{
meanimp(survival.data, round = FALSE)
}
\arguments{
\item{survival.data}{A matrix of two columns with the first column indicates
the survival time and the second column indicates the event indicator (1 and 
0, where 1 indicates observed event and 0 indicates unobserved event).}

\item{round}{Whether survival time should be rounded, default = FALSE.}
}
\value{
\code{meanimp} returns a list containing the following components:
\item{imputed_table}{A matrix containing the original survival data and the 
imputed time.}
\item{KM_table}{Kaplan-Meier estimator of failure times.}
}
\description{
In this approach, \eqn{\mu} can be computed using the familiar sample mean
formula provided the censored values are imputed.
}
\examples{
## Generate the survival data
data_test <- matrix(c(1, 1, 1, 2.5, 5, 7, 1, 1, 0, 1, 0, 1), ncol = 2)

## Mean imputation
meanimp(data_test, round = FALSE)

}
