% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{g.test}
\alias{g.test}
\title{Replicated G-tests of goodness-of-fit}
\usage{
g.test(x)
}
\arguments{
\item{x}{a matrix or data frame with two numeric columns;
first column is for left-side and 2nd column for right-side.
Identifiers for hosts can be provided as row names.}
}
\value{
A list containing two data.frames:
 \item{summary}{results of total, heterogeneity and pooled G-tests.
   Data frame has four columns: test, degrees of freedom, G-statistic and p-value.}
 \item{hosts}{results of individual G-tests on distribution of parasites in each host.
   Data frame has seven columns: Host (ID), Left (count of parasites on left side),
   Right (count of parasites on right side), G (G-statistic), p (p-value), BH (p-value adjusted
   using Benjamini and Hochberg's procedure for controlling the false discovery rate) and Holm (p-value
   adjusted using Holm's method).}
}
\description{
Perform replicated G-tests of goodness-of-fit to assess symmetry of parasitic infections.
}
\details{
This function implements Sokal & Rohlf's (1995) G-test for the specific case of an expected 1:1 ratio
The function takes as its argument a matrix or data frame with two numeric columns; first column is for
left-side and 2nd column for right-side. Identifiers for hosts can be provided as row names. Uninfected
hosts (zero count for both left and right sides) are ignored. Cannot be applied to data containing zero
counts; use eb.test instead.
}
\examples{
g.test(diplostomum_eyes_excl_lenses)
}
\references{
R.R. Sokal & F.J. Rohlf (1995) Biometry. 3rd Edition. New York: W.H. Freeman and Company. 887 pp.
}

