% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotVolcano}
\alias{plotVolcano}
\title{Volcano plot}
\usage{
plotVolcano(x, test = "G", pAdj = "BH", sigThresh = 0.05, ...)
}
\arguments{
\item{x}{a matrix or data frame with two numeric columns; first column is for left-side and 2nd column
for right-side. Identifiers for hosts can be provided as row names.}

\item{test}{if set to "G" (default) a G-test is performed; otherwise an exact binomial test is performed.}

\item{pAdj}{method for correcting p-values for multiple comparisons. If set to "BH" (default), Benjamini
& Hochberg's procedure is used to control the false discovery rate (FDR); otherwise Holm's methos is used
to control the familywise error rate (FWER).}

\item{sigThresh}{significance threshold (defaults to 0.05); p-values below this value will be called significant.}

\item{...}{optional further arguments and graphical parameters passed to plot.}
}
\description{
Produces scatterplot of statistical significance vs fold difference in parasite abundance
between left and right.
}
\details{
plot.Volcano creates a volcano plot, i.e. a scatterplot of statistical significance
(-log10(p-value)) vs fold difference (log2 ratio - as calculated for the histogram above)
in parasite abundance between left and right. Each point in the scatterplot represents the
parasite distribution in an individual host. A dashed horizontal line represents the user-defined
p-value threshold for significance. If a parasite distribution deviates significantly from symmetry
it is shown as a red square, otherwise as a blue circle.
}
\examples{
plotVolcano(diplostomum_eyes_excl_lenses)
plotVolcano(diplostomum_eyes_excl_lenses, test="G", pAdj="BH", sigThresh=0.1,
main="Diplostomum metacercariae in eyes of ruffe")
}

