% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_attrib.R
\name{est_attrib}
\alias{est_attrib}
\title{Estimates simulations of expected responses}
\usage{
est_attrib(fit, data, exposures, n_sim = 500)
}
\arguments{
\item{fit}{A model fit constructed by fit_attrib}

\item{data}{The observed data}

\item{exposures}{The exposures that will get reference expected mortalities}

\item{n_sim}{Number of simulations

For more details see the help vignette:
\code{vignette("intro", package="attrib")}}
}
\value{
Dataset with expected responses for all simulations including expected responses given the exposure reference values
}
\description{
For each exposure the dataset is copied and the original value replaced by the reference value.
Then the sim function is used to generate 500 simulations of expected responses for each row.
Finally the dataset is transformed to obtain expected response for original and reference values
of the given exposures for each original row of the dataset.
}
\details{
The burden method is based on Nielsen, Krause, Molbak <doi:10.1111/irv.12564>.

For more details see the help vignette:
\code{vignette("intro", package="attrib")}
}
\examples{

response <- "deaths"
fixef <- "pr100_ili_lag_1 + sin(2 * pi * (week - 1) / 52) + cos(2 * pi * (week - 1) / 52)"
ranef <- " (pr100_ili_lag_1| season)"
offset <- "log(pop)"

data <- attrib::data_fake_nation

fit <- fit_attrib(data = data, response = response, fixef = fixef, ranef = ranef, offset = offset)
exposures <- c(pr100_ili_lag_1 = 0)
n_sim <- 5
new_data <- est_attrib(fit, data, exposures, n_sim)
new_data[]

}
