% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs.R
\name{get_recurrence_covariates}
\alias{get_recurrence_covariates}
\title{Generate the binary recurrence covariates for the identified candidate empirical covariates}
\usage{
get_recurrence_covariates(
  df,
  patientIdVarname,
  eventCodeVarname,
  patientIdVector
)
}
\arguments{
\item{df}{The input \code{data.frame}. Ideally this should be the output \code{covars_data}
from \code{\link[autoCovariateSelection]{get_candidate_covariates}}}

\item{patientIdVarname}{The variable name which contains the patient identifier in the \code{df}}

\item{eventCodeVarname}{The variable name which contains the covariate codes (eg:- CCS, ICD9) in the \code{df}}

\item{patientIdVector}{The 1-D vector with all the patient identifiers. This should contain all the patient IDs in the original two
cohorts. This vector can simply be the \code{patientIds} output vector of the \code{get_candidate_covariates} function.
of the function}
}
\value{
A named list containing two R objects
\itemize{
\item \code{recurrence_data}   A \code{data.frame} containing all the binary recurrence covariates for all the patients in wide format.
This means that this \code{data.frame} will have a dimension with number of rows equal to number of distinct patients and number of
columns equal to number of binary recurrence covariates plus 1 (for the patient Id variable). The binary recurrence covariate is prefixed with
a 'rec_' to indicate that the covariate is a 'reccurrence covariate' and suffixed with '_once', '_sporadic' or '_frequent'.
See \code{details} section above for details.
\item \code{patientIds}   {The list of patient ids present in the original input \code{df}. This is exactly the same as the input \code{patientIdVector}}
}
}
\description{
\code{get_recurrence_covariates} function assesses the recurrence of each of the identified candidate empirical covariates
based on their frequency of occurrence for each patient in the baseline period and generates three binary recurrence covariates
for each of the identified candidate empirical covariates. This is the second step in the automated covariate selection process.
The first step of identifying empirical candidate covariates is done via \code{\link[autoCovariateSelection]{get_candidate_covariates}} function.
See 'Automated Covariate Selection'section below for more details regarding the overall process.
}
\details{
The recurrence covariates are generated based on the frequency (counts) of occurrence of each empirical candidate covariates that got
generated by the \code{generate_candidate_covariates} function. This is done by looking at the baseline period of each patients and
assessing whether the covariate occurred only once or sporadically or frequently. That is, a maximum of three recurrence covariates
for each candidate covariate is created and returned.
\itemize{
\item \code{once} Indicates whether or not the covariate occurred more than or equal to 1 number of times for the patient
\item \code{sporadic} Indicates whether or not the covariate occurred more than or equal to median (median of non-zero occurrences of
the candidate covariate) number of times for the patient.
\item \code{frequent} Indicates whether or not the covariate occurred more than or equal to upper quartile (75th percentile of non-zero
occurrences of the candidate covariate) number of times for the patient
}
Note that if two or all three covariates are identical for any of the binary recurrence covariates, only the distinct recurrence covariate
is returned. For example, if once == sporadic == frequent for the candidate covariate (median and upper quartile both are 1), then only the 'once' recurrence covariate is
returned. If once != sporadic == frequent, then 'once' and 'sporadic' is returned. If once == sporadic != frequent, then 'once'
and 'frequent' are returned. If none of three recurrence covariates are identical, then all three are returned.
The theoretical details of the algorithm implemented is detailed in the publication listed below in the \code{References} section.
\code{get_recurrence_covariates} is the function implementing what is described in the 'Assess Recurrence' section
of the article.
}
\section{Automated Covariate Selection}{

\strong{The three steps in automated covariate selection are listed below with the functions implementing the methodology}
\enumerate{
\item Identify candidate empirical covariates: \code{\link[autoCovariateSelection]{get_candidate_covariates}}
\item Assess recurrence: \code{\link[autoCovariateSelection]{get_recurrence_covariates}}
\item Prioritize covariates: \code{\link[autoCovariateSelection]{get_prioritised_covariates}}
}
}

\examples{
library("autoCovariateSelection")
data(rwd)
head(rwd, 3)
basetable <- rwd \%>\% select(person_id, treatment, outcome_date) \%>\% distinct()
head(basetable, 3)
patientIds <- basetable$person_id
step1 <- get_candidate_covariates(df = rwd,  domainVarname = "domain",
eventCodeVarname = "event_code" , patientIdVarname = "person_id",
patientIdVector = patientIds,n = 100, min_num_patients = 10)
out1 <- step1$covars_data
all.equal(patientIds, step1$patientIds) #should return  TRUE
step2 <- get_recurrence_covariates(df = out1, patientIdVarname = "person_id",
eventCodeVarname = "event_code", patientIdVector = patientIds)
out2 <- step2$recurrence_data
}
\references{
Schneeweiss S, Rassen JA, Glynn RJ, Avorn J, Mogun H, Brookhart MA. High-dimensional propensity score adjustment in studies of treatment effects using health care claims data Epidemiology. 2009;20(4):512-522. doi:10.1097/EDE.0b013e3181a663cc
}
\author{
Dennis Robert \email{dennis.robert.nm@gmail.com}
}
