% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_reliability.R
\name{empirical_reliability}
\alias{empirical_reliability}
\title{Calculate the Empirical Reliability of the Latent Trait Scores,
Following the Formula in Brown & Maydeu-Olivares (2018).}
\usage{
empirical_reliability(dataset, score_names, se_names)
}
\arguments{
\item{dataset}{Data frame with trait estimates and standard errors}

\item{score_names}{Vector of characters. Which columns specify trait scores?}

\item{se_names}{Vector of characters. Which columns specify trait standard errors?}
}
\value{
A numeric vector containing empirical reliability estimates, ordered the same as in \code{score_names}.
}
\description{
Calculates the empirical reliability using the formula in Brown & Maydeu-Olivares (2018).
}
\details{
For trait scores estimated using item response theory models, a suitable reliability estimate
is empirical reliability, which provides a summary estimate on how reliable the trait scores are "as a whole".
}
\examples{
\dontrun{empirical_reliability(dataset, c("Trait1", "Trait2", "Trait3"), c("se1", "se2", "se3"))}

}
\references{
Brown, A., & Maydeu-Olivares, A. (2018). Ordinal factor analysis of graded-preference questionnaire data. 
\emph{Structural Equation Modeling: A Multidisciplinary Journal, 25}(4), 516-529. https://doi.org/10.1080/10705511.2017.1392247
}
\author{
Mengtong Li
}
