% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{copy_e2e}
\alias{copy_e2e}
\title{Copy an object from one env to another.}
\usage{
copy_e2e(from_obj, from_env, to_obj, to_env)
}
\arguments{
\item{from_obj}{The name of the object to copy. It has to be a string.}

\item{from_env}{The environment in which the object lives. It has to be an
object of class environment.}

\item{to_obj}{The name of the object to assign it to, in the new environment.
Also a string.}

\item{to_env}{The environment to which the new object is to be assigned. It
has to be an object of class environment.}
}
\value{
There is no return value. This function is called for its' side
effect.
}
\description{
A wrapper function that uses assign and get.
}
\examples{

e1 <- new.env(); e2 <- new.env()
ls(e2)
evalq(x <- 1L, e1)
copy_e2e("x", e1, "y", e2)
ls(e2)
}
