% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_size.R
\name{env_size}
\alias{env_size}
\title{Calculates the Total Memory Used}
\usage{
env_size(env)
}
\arguments{
\item{env}{The environment whose size is to be computed.}
}
\value{
The size in bytes, as a numeric value (scalar).
}
\description{
This function uses the utils package to compute the total
amount of memory used by objects in an environment.
}
\details{
The names are wrapped in backticks. Otherwise, non-syntactic
names will cause problems. This function is used within
\code{\link{render_one}} as part of the runtime stats assessment.
}
\examples{

e1 <- new.env()
env_size(e1)
evalq(x <- 1:10000L, e1)
env_size(e1)
}
