% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_predict.R
\name{tidy_predict}
\alias{tidy_predict}
\alias{tidy_predict.Rcpp_ENSEMBLE}
\alias{tidy_predict.glm}
\alias{tidy_predict.default}
\alias{tidy_predict.BinaryTree}
\alias{tidy_predict.xgb.Booster}
\alias{tidy_predict.lgb.Booster}
\title{tidy predict}
\usage{
tidy_predict(
  model,
  newdata,
  form = NULL,
  olddata = NULL,
  bind_preds = FALSE,
  ...
)

\method{tidy_predict}{Rcpp_ENSEMBLE}(model, newdata, form = NULL, ...)

\method{tidy_predict}{glm}(model, newdata, form = NULL, ...)

\method{tidy_predict}{default}(model, newdata, form = NULL, ...)

\method{tidy_predict}{BinaryTree}(model, newdata, form = NULL, ...)

\method{tidy_predict}{xgb.Booster}(
  model,
  newdata,
  form = NULL,
  olddata = NULL,
  bind_preds = FALSE,
  ...
)

\method{tidy_predict}{lgb.Booster}(
  model,
  newdata,
  form = NULL,
  olddata = NULL,
  bind_preds = FALSE,
  ...
)
}
\arguments{
\item{model}{model}

\item{newdata}{dataframe}

\item{form}{the formula used for the model}

\item{olddata}{training data set}

\item{bind_preds}{set to TURE if newdata is a dataset without any labels, to bind the new and old data with the predictions under the original target name}

\item{...}{other parameters to pass to \code{predict}}
}
\value{
dataframe
}
\description{
tidy predict
}
\examples{
iris \%>\%
 framecleaner::create_dummies(Species) -> iris_dummy

iris_dummy \%>\%
 tidy_formula(target= Petal.Length) -> petal_form

iris_dummy \%>\%
 tidy_xgboost(
   petal_form,
   trees = 20,
   mtry = .5
 )  -> xg1


xg1 \%>\%
 tidy_predict(newdata = iris_dummy, form = petal_form) \%>\%
 head()

}
