% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_lm.R
\name{confint.avlm}
\alias{confint.avlm}
\title{Confidence Intervals for Anytime-Valid lm (avlm) Objects}
\usage{
\method{confint}{avlm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{An \code{avlm} object.}

\item{parm}{A specification of which parameters are to be given confidence intervals; can be a vector of numbers or names.}

\item{level}{The confidence level required for the intervals. Defaults to 0.95.}

\item{...}{Additional arguments passed to or from other methods.}
}
\value{
A matrix with the lower and upper confidence limits for the specified parameters.
}
\description{
Computes confidence intervals for the coefficients of an \code{avlm} object by adjusting
the standard errors using the precision parameter \code{g} and an anytime-valid approach.
}
\examples{
# Fit a simple linear model using the mtcars dataset
fit <- lm(mpg ~ wt + hp, data = mtcars)

# Convert the standard lm object to an anytime-valid avlm object with precision parameter g = 1
av_fit <- av(fit, g = 1)

# Calculate and print confidence intervals for the coefficients
conf_intervals <- confint(av_fit)
print(conf_intervals)

}
