% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_function}
\alias{get_function}
\alias{list_functions}
\alias{list_function_versions}
\alias{delete_function}
\alias{get_function_policy}
\title{Function Management}
\usage{
get_function(name, qualifier, ...)

list_functions(marker, n, ...)

list_function_versions(name, marker, n, ...)

delete_function(name, qualifier, ...)

get_function_policy(name, qualifier, ...)
}
\arguments{
\item{name}{A character string specifying the function name (either a full ARN or a max 64-character string). For functions other than \code{create_function} this can also be an object of class \dQuote{aws_lambda_function}.}

\item{qualifier}{Optionally, either a function version or alias. If omitted, information about the latest version is returned.}

\item{\dots}{Additional arguments passed to \code{\link{lambdaHTTP}}.}

\item{marker}{A pagination marker from a previous request.}

\item{n}{An integer specifying the number of results to return.}
}
\value{
An object of class \dQuote{aws_lambda_function}.
}
\description{
List functions, function versions, and function policies
}
\details{
\code{list_functions} lists all functions. \code{get_function}
  retrieves a specific function and \code{list_function_versions} retrieves
  all versions of that function. \code{get_function_policy} returns the
  resource-based IAM policy for a function. \code{delete_function} deletes a
  function, if you have permission to do so.
}
\references{
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunction.html}{API
Reference: GetFunction}
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_ListVersionsByFunction.html}{API
Reference: ListVersionsByFunction}
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctions.html}{API
Reference: ListFunctions}
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_GetPolicy.html}{API
Reference: GetPolicy}
}
\seealso{
\code{\link{create_function}}, \code{\link{update_function_code}},
  \code{\link{update_function_config}}
}
