% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{transcribeHTTP}
\alias{transcribeHTTP}
\title{Execute AWS Transcribe API Request}
\usage{
transcribeHTTP(
  action,
  headers = list(),
  query = list(),
  body = NULL,
  version = "v1",
  verbose = getOption("verbose", FALSE),
  region = Sys.getenv("AWS_DEFAULT_REGION", "us-east-1"),
  key = NULL,
  secret = NULL,
  session_token = NULL,
  ...
)
}
\arguments{
\item{action}{A character string specifying an API endpoint.}

\item{headers}{A list of headers to pass to the HTTP request.}

\item{query}{An optional named list containing query string parameters and their character values.}

\item{body}{A request body}

\item{version}{A character string specifying the API version.}

\item{verbose}{A logical indicating whether to be verbose. Default is given by \code{options("verbose")}.}

\item{region}{A character string specifying an AWS region. See \code{\link[aws.signature]{locate_credentials}}.}

\item{key}{A character string specifying an AWS Access Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{secret}{A character string specifying an AWS Secret Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{session_token}{Optionally, a character string specifying an AWS temporary Session Token to use in signing a request. See \code{\link[aws.signature]{locate_credentials}}.}

\item{...}{Additional arguments passed to \code{\link[httr]{GET}}.}
}
\value{
If successful, a named list. Otherwise, a data structure of class \dQuote{aws-error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
This is the workhorse function to execute calls to the Transcribe API.
}
\details{
This function constructs and signs an Transcribe API request and returns the results thereof, or relevant debugging information in the case of error.
}
\author{
Thomas J. Leeper
}
