% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{cran_package}
\alias{cran_package}
\title{Specifies a CRAN package to install in environment}
\usage{
cran_package(name, version = NULL, repo = "https://cloud.r-project.org")
}
\arguments{
\item{name}{The package name}

\item{version}{A string of the package version. If not provided, version
will default to latest}

\item{repo}{The base URL of the repository to use, e.g., the URL of a
CRAN mirror. If not provided, the package will be pulled from
"https://cloud.r-project.org".}
}
\value{
A named list containing the package specifications
}
\description{
Specifies a CRAN package to install in run environment
}
\section{Examples}{
\preformatted{pkg1 <- cran_package("ggplot2", version = "3.3.0")
pkg2 <- cran_package("stringr")
pkg3 <- cran_package("ggplot2", version = "0.9.1",
                     repo = "http://cran.us.r-project.org")

env <- r_environment(name = "r_env",
                     cran_packages = list(pkg1, pkg2, pkg3))
}
}

\seealso{
\code{\link[=r_environment]{r_environment()}}
}
