% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bagged.outliertrees.R
\name{predict.bagged.outliertrees}
\alias{predict.bagged.outliertrees}
\title{Predict method for Bagged OutlierTrees}
\usage{
\method{predict}{bagged.outliertrees}(
  object,
  newdata,
  min_outlier_score = 0.95,
  nthreads = parallel::detectCores(),
  ...
)
}
\arguments{
\item{object}{A Bagged OutlierTrees object as returned by \code{bagged.outliertrees}.}

\item{newdata}{A Data Frame in which to look for outliers according to the fitted model.}

\item{min_outlier_score}{Minimum outlier score to use when finding outliers.}

\item{nthreads}{Number of threads to use when predicting.}

\item{...}{No use.}
}
\value{
Will return a list of lists with the outliers and their
information (each row is an entry in the first list, with the same names as the rows in the input data
frame), which can be printed into a human-readable format after-the-fact through functions
\code{print}.
}
\description{
Predict method for Bagged OutlierTrees
}
\examples{
library(bagged.outliertrees)

### example dataset with interesting outliers
data(hypothyroid)

### fit a Bagged OutlierTrees model
model <- bagged.outliertrees(hypothyroid,
  ntrees = 10,
  subsampling_rate = 0.5,
  z_outlier = 6,
  nthreads = 1
)

### use the fitted model to find outliers in the training dataset
outliers <- predict(model,
  newdata = hypothyroid,
  min_outlier_score = 0.5,
  nthreads = 1
)

### print the top-10 outliers in human-readable format
print(outliers, outliers_print = 10)
}
\seealso{
\link{bagged.outliertrees} \link{print.bagged.outlieroutputs}
}
