% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subset_data_nplcm_by_index}
\alias{subset_data_nplcm_by_index}
\title{subset data from the output of \code{\link[=clean_perch_data]{clean_perch_data()}}}
\usage{
subset_data_nplcm_by_index(data_nplcm, index)
}
\arguments{
\item{data_nplcm}{data for fitting nplcm; See \code{\link[=nplcm]{nplcm()}}}

\item{index}{a vector of indices indicating the observations you hope to subset;
it will subset in all the sublists of data_nplcm}
}
\value{
a list with the requested data, in the order determined by 'index'
}
\description{
It is particularly useful in simulating data from a regression model where one
generates a case and control at a particular covariate value, and just choose
a case or control to retain in the simulated data.
}
\examples{

J = 3                          # number of causes
cause_list = c(LETTERS[1:J])   # cause list
K = 2                          # number of subclasses
lambda = c(1,0)                # subclass weights for control group
eta = c(1,0)                   # subclass weights for case group

# setup parameters for the present individual:
set_parameter <- list(
 cause_list      = cause_list,
 etiology        = c(0.5,0.2,0.3), # only meaningful for cases 
 pathogen_BrS    = LETTERS[1:J],
 pathogen_SS     = LETTERS[1:2],
 meas_nm         = list(MBS = c("MBS1"),MSS=c("MSS1")),
 Lambda          = lambda,         # for BrS   
 Eta             = t(replicate(J,eta)),  # case subclass weight for BrS
 PsiBS           = cbind(c(0.15,0.3,0.35),   
                         c(0.25,0.2,0.15)), # FPR
 PsiSS           = cbind(rep(0,J),rep(0,J)),
 ThetaBS         = cbind(c(0.95,0.9,0.85),    # TPR
                         c(0.95,0.9,0.85)),
 ThetaSS         = cbind(c(0.25,0.10),
                         c(0.25,0.10)),
 Nd      =     5,
 Nu      =     3 
)
simu_out   <- simulate_nplcm(set_parameter)
out <- simu_out$data_nplcm
out
subset_data_nplcm_by_index(out,c(1,4,5))
subset_data_nplcm_by_index(out,2)

}
\seealso{
Other data operation functions: 
\code{\link{combine_data_nplcm}()},
\code{\link{merge_lists}()}
}
\concept{data operation functions}
