% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_utils.R
\name{estimate}
\alias{estimate}
\title{Estimate/variance of policy evaluation via non-contextual weighting.}
\usage{
estimate(w, gammahat, policy)
}
\arguments{
\item{w}{Numeric vector. Non-contextual weights, length \code{A}. Must not contain NA values.}

\item{gammahat}{Numeric matrix. AIPW scores, shape \code{[A, K]}. Must not contain NA values.}

\item{policy}{Numeric matrix. Policy matrix \eqn{\pi(X_t, w)}, shape \code{[A, K]}. Must have the same shape as \code{gammahat} and must not contain NA values.}
}
\value{
Named numeric vector with elements \code{estimate} and \code{var}, representing the estimated
policy value and the variance of the estimate, respectively.
}
\description{
Computes the estimate and variance of a policy evaluation based on non-contextual weights, AIPW scores,
and a policy matrix.
}
\examples{
w <- c(0.5, 1, 0.5, 1.5)
scores <- matrix(c(0.5, 0.8, 0.6,
                   0.3, 0.9, 0.2,
                   0.5, 0.7, 0.4,
                   0.8, 0.2, 0.6), ncol = 3, byrow = TRUE)
policy <- matrix(c(0.2, 0.3, 0.5,
                   0.6, 0.1, 0.3,
                   0.4, 0.5, 0.1,
                   0.2, 0.7, 0.1), ncol = 3, byrow = TRUE)
gammahat <- scores - policy
estimate(w = w, gammahat = gammahat,
policy = policy)

}
