% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{simple_tree_data}
\alias{simple_tree_data}
\title{Generate simple tree data.}
\usage{
simple_tree_data(
  A,
  K = 5,
  p = 10,
  noise_std = 1,
  split = 1.676,
  signal_strength = 1,
  noise_form = "normal"
)
}
\arguments{
\item{A}{Integer. Number of observations in the dataset. Must be a positive integer.}

\item{K}{Integer. Number of arms. Must be a positive integer.}

\item{p}{Integer. Number of covariates. Must be a positive integer.}

\item{noise_std}{Numeric. Standard deviation of the noise added to the potential outcomes. Must be a non-negative number.}

\item{split}{Numeric. Split point for creating treatment groups based on the covariates.}

\item{signal_strength}{Numeric. Strength of the signal in the potential outcomes.}

\item{noise_form}{Character. Distribution of the noise added to the potential outcomes. Can be either "normal" or "uniform".}
}
\value{
A list containing the generated data (\code{xs}, \code{ys}, \code{muxs}) and the true potential outcome means (\code{mus}).
}
\description{
Generates covariates and potential outcomes of a synthetic dataset for a simple tree model.
}
\examples{
set.seed(123)
A <- 1000
K <- 4     # Number of treatment arms
p <- 10    # Number of covariates
synthetic_data <- simple_tree_data(A = A,
                                   K = K,
                                   p = p,
                                   noise_std = 1.0,
                                   split = 1.676,
                                   signal_strength = 1.0,
                                   noise_form = 'normal')

}
