% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fg_milb_batter_game_logs.R
\name{fg_milb_batter_game_logs}
\alias{fg_milb_batter_game_logs}
\title{\strong{Scrape MiLB game logs for batters from FanGraphs}}
\usage{
fg_milb_batter_game_logs(playerid, year)
}
\arguments{
\item{playerid}{The batter's minor league ID from FanGraphs.}

\item{year}{The season for which game logs should be returned.}
}
\value{
Returns a tibble of Minor League batter game logs with the following columns:\tabular{ll}{
   col_name \tab types \cr
   player_name \tab character \cr
   minor_playerid \tab character \cr
   Date \tab character \cr
   Team \tab character \cr
   Level \tab character \cr
   Opp \tab character \cr
   G \tab numeric \cr
   AB \tab numeric \cr
   PA \tab numeric \cr
   H \tab numeric \cr
   1B \tab numeric \cr
   2B \tab numeric \cr
   3B \tab numeric \cr
   HR \tab numeric \cr
   R \tab numeric \cr
   RBI \tab numeric \cr
   BB \tab numeric \cr
   IBB \tab numeric \cr
   SO \tab numeric \cr
   HBP \tab numeric \cr
   SF \tab numeric \cr
   SH \tab numeric \cr
   GDP \tab numeric \cr
   SB \tab numeric \cr
   CS \tab numeric \cr
   AVG \tab numeric \cr
   BB\% \tab numeric \cr
   K\% \tab numeric \cr
   BB/K \tab numeric \cr
   OBP \tab numeric \cr
   SLG \tab numeric \cr
   OPS \tab numeric \cr
   ISO \tab numeric \cr
   Spd \tab numeric \cr
   BABIP \tab numeric \cr
   wRC \tab numeric \cr
   wRAA \tab numeric \cr
   wOBA \tab numeric \cr
   wRC+ \tab numeric \cr
   wBsR \tab numeric \cr
   gamedate \tab character \cr
   dh \tab integer \cr
   UPId \tab character \cr
   MLBAMId \tab character \cr
   MinorMasterId \tab character \cr
   RRId \tab character \cr
   FirstName \tab character \cr
   LastName \tab character \cr
   firstLastName \tab character \cr
   Height \tab character \cr
   Weight \tab character \cr
   BirthDate \tab character \cr
   Bats \tab character \cr
   Throws \tab character \cr
   Position \tab character \cr
   BirthCity \tab character \cr
   College \tab character \cr
   Age \tab character \cr
}
}
\description{
This function allows you to scrape MiLB game logs for individual batters from FanGraphs.
}
\examples{
\donttest{
  try(fg_milb_batter_game_logs(playerid = "sa3019999", year=2023))
}
}
