% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_ACF_plot.R
\name{trace_ACF_plot}
\alias{trace_ACF_plot}
\title{Trace and/or ACF plots of elements of a variable
 in \code{bmrm} object}
\usage{
trace_ACF_plot(x,var="P", ACF=FALSE, nplot=0,irow=1, icol=1, saveFile=FALSE,...)
}
\arguments{
\item{x}{an object of class \code{bmrm}, the output of the \code{bmrm} function}

\item{var}{name of a variable to which the plots apply.  It should be one of
"A" (source contribution matrix),
"P" (source composition matrix),
"Sigma" (error variance).}

\item{ACF}{TRUE/FALSE  if TRUE ACF plots will be provided along with
effective sample sizes(dafault: FALSE)}

\item{nplot}{number of elements of 'var' for trace and/or ACF plots.
If 'nplot' is
 smaller than the total number of elements of 'var' then plots of
 'nplot' selected elements will be drawn. Otherwise, trace and/or ACF plots of  all
  elements will be drawn.
   (default=0  implies that all elements will be selected if var="P" or "Sigma",
   and the first 12 elements will be selected  if  var="A")}

\item{irow}{row index of A/P matrix or index of element of Sigma vector.
Plots of 'nplot' elements starting from (irow, icol) element of A/P or
elements starting from irow element of Sigma will be drawn (default=1).}

\item{icol}{column number of  A/P matrix.  Plots of 'nplot' elements starting
from (irow, icol) element of A/P will be drawn (default=1).}

\item{saveFile}{TRUE/FALSE, save the plots in file
\emph{'var'-trace.pdf} (default=FALSE)}

\item{...}{arguments to be passed to methods}
}
\value{
plot
}
\description{
Produce trace and Auto-Correlation Function
  plots (along with Effective sample size) of MCMC samples
 of  elements of A, nonzero elements of P, elements of Sigma.
}
\examples{
\donttest{
data(Elpaso); Y=Elpaso$Y ; muP=Elpaso$muP ; q=nrow(muP)
out.Elpaso <- bmrm(Y,q,muP, nAdapt=1000,nBurnIn=5000,nIter=5000,nThin=1)
trace_ACF_plot(out.Elpaso,"Sigma", ACF=TRUE)
trace_ACF_plot(out.Elpaso,"P", ACF=TRUE)
trace_ACF_plot(out.Elpaso,"A",ACF=TRUE, nplot=12, irow=2, icol=3)
}
}
