% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{jdpar.asymp}
\alias{jdpar.asymp}
\title{Joint asymptotic mutivariate density of parameters}
\usage{
jdpar.asymp(drabj, data, jdF = FALSE, vcovfn = "vcovHC", ...)
}
\arguments{
\item{drabj}{object from dr_asympar()}

\item{data}{dataframe, first column is the outcome}

\item{jdF}{logical to return joint density of F(yo) across thresholds in drabj}

\item{vcovfn}{a string denoting the function to extract the variance-covariance. Defaults at
"vcov". Other variance-covariance estimators in the sandwich package are usable.}

\item{...}{additional input to pass to \code{vcovfn}}
}
\value{
mean vector Theta and variance-covariance matrix vcovpar of parameters across 
thresholds and if \code{jdF=TRUE}, 
a mean vector \code{mnF} and a variance-covariance matrix \code{vcovF} of F(yo)
}
\description{
\code{jdpar.asymp} takes input object from dr_asympar() for asymptotic bayesian distribution.
It returns objects for joint mutivariate density of parameters across several thresholds.
Check for positive definiteness of the covariance matrix, else exclude thresholds yielding
negative eigen values.
}
\examples{
y = faithful$waiting
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
qtaus = quantile(y,c(0.05,0.25,0.5,0.75,0.95))
drabj<- dr_asympar(y=y,x=x,thresh = qtaus); data = data.frame(y,x)
(drjasy = jdpar.asymp(drabj=drabj,data=data,jdF=TRUE))

}
