% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{bic}
\alias{bic}
\title{Computes posterior sample of the pointwise BIC method from a varstan object}
\usage{
bic(x)
}
\arguments{
\item{x}{A varstan object of the time series fitted model.}
}
\value{
A numeric array  of size R, containing the posterior samples of the aic
for a varstan object, where R is the number of iterations. If multiple chains are
fitted, then the array is of length M*R, where M is the number of chains
}
\description{
Convenience function for computing the pointwise Bayesian Information Criteria
method from a varstan object.
}
\examples{

\donttest{
 model = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
 fit1 = varstan(model,iter = 500,chains = 1)

 bic1 = bic(fit1)
 mean(bic1)
}

}
\author{
Asael Alonzo Matamoros
}
