% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{predictplot}
\alias{predictplot}
\title{Simple plot of \code{prediction} with intervals.}
\usage{
predictplot(y, x = NULL, probs = c(0.05, 0.5, 0.95),
  poly_col = grDevices::rgb(0, 0, 0, 0.1), ...)
}
\arguments{
\item{y}{A \code{prediction} object to plot.}

\item{x}{Optional vector or NULL, indicating were \code{prediction} 
inferences fall along x-axis. Must be the same length as the inferred values 
in \code{y}.}

\item{probs}{Optional 3-member Vector of numerics indicating low, middle, and 
high probability intervals to plot. All must be <= 1.}

\item{poly_col}{Optional color for interval polygon.}

\item{...}{Additional arguments passed to \code{plot}.}
}
\description{
Simple plot of \code{prediction} with intervals.
}
\examples{
data(bassriver)

# Using the "pooled annual" calibration model:
sst <- predict_seatemp(bassriver$d18o, d18osw=0.0, 
                       prior_mean=30.0, prior_std=20.0)

predictplot(x=bassriver$depth, y=sst, ylim=c(20, 40), 
            ylab="SST (°C)", xlab="Depth (m)")

}
