% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_bw_estimate.R
\name{boot_bw_estimate}
\alias{boot_bw_estimate}
\title{Estimate median and confidence intervals from bootstrap replicates}
\usage{
boot_bw_estimate(boot_df)
}
\arguments{
\item{boot_df}{A \code{\link[=data.frame]{data.frame()}} or a list of \code{\link[=data.frame]{data.frame()}}s of bootstrap
replicates with columns for each indicator to estimate. This is produced
by a call to \code{\link[=boot_bw]{boot_bw()}}.}
}
\value{
A \code{\link[=data.frame]{data.frame()}} with rows equal to the number of columns of
\code{boot_df} and 4 columns for \strong{indicator}, \strong{estimate},
\strong{95\% lower confidence limit}, and \strong{95\% upper confidence limit}.
}
\description{
Estimate median and confidence intervals from bootstrap replicates
}
\examples{
boot_df <- boot_bw(
  x = indicatorsHH, w = villageData, statistic = bootClassic,
  params = "anc1", parallel = TRUE, replicates = 9
)

boot_bw_estimate(boot_df)

}
