% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease-model.R
\name{rho_mlogit}
\alias{rho_mlogit}
\title{Fitting disease models via multinomial logistic models}
\usage{
rho_mlogit(formula, data, test = FALSE, maxit = 500, trace = FALSE)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame containing the variables in the model.}

\item{test}{a logical value indicating whether p-values of the regression coefficients should be returned. Default \code{FALSE}.}

\item{maxit}{maximum number of iterations. Default 500.}

\item{trace}{switch for tracing estimation process. Default \code{FALSE}.}
}
\value{
\code{rho_mlogit} returns a list containing the following components:
 \item{coeff}{a vector of estimated coefficients.}
 \item{values}{fitted values of the model.}
 \item{Hess}{the Hessian of the measure of fit at the estimated coefficients.}
 \item{D}{the disease status vector used.}
 \item{X}{a design model matrix.}
 \item{formula}{the fomular supplied.}
}
\description{
\code{rho_mlogit} is used to fit multinomial logistic models to the disease process in the verified subjects.
}
\details{
In the formula, the response must be a result of \code{\link{pre_data}}, a factor with three levels, say 1, 2, 3. These levels correspond to three classes of disease status, e.g., non-dieseased, intermediate, diseased. The last class (class 3) is considered as the reference level in multinomal logistic model. In presence of verification bias, the missing (\code{NA}) values correspond to non verified subjects.
}
\examples{
data(EOC)
dise_na <- pre_data(EOC$D, EOC$CA125)
dise_fact_na <- dise_na$dise
out <- rho_mlogit(dise_fact_na ~ CA125 + CA153 + Age, data = EOC,
                  test = TRUE, trace = TRUE)

}
\references{
To Duc, K., Chiogna, M. and Adimari, G. (2016)
Bias-corrected methods for estimating the receiver operating characteristic surface of continuous diagnostic tests.
\emph{Electronic Journal of Statistics}, \bold{10}, 3063-3113.
}
\seealso{
\code{\link[nnet]{multinom}}, \code{\link[nnet]{nnet}}
}
