% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{generateDatabase}
\alias{generateDatabase}
\title{Generates a number of datasets from one metadata scenario}
\usage{
generateDatabase(
  name = NULL,
  setnr = NULL,
  draws = 1,
  seedinfo = list(100, paste(R.version$major, R.version$minor, sep = "."), RNGkind()),
  metaseedinfo = list(100, paste(R.version$major, R.version$minor, sep = "."),
    RNGkind()),
  file = NULL,
  seedincrement = 1
)
}
\arguments{
\item{name}{The path to the setup file}

\item{setnr}{The metadata scenario, as taken from the info table}

\item{draws}{The number of datasets that are drawn from the metadata scenario}

\item{seedinfo}{The random number generator seed parameters}

\item{metaseedinfo}{If necessary, a separate set of random number generator parameters for the metadata (e.g. cluster centers)}

\item{file}{A custom file name for the output database. Defaults to the pattern setupname_setnr_seed.db}

\item{seedincrement}{The random number seed will by default increase by 1 for each draw from the base seed given in seedinfo unless specified otherwise here}
}
\value{
An SQLite database that contains the desired number of data sets drawn from a certain metadata scenario
}
\description{
Generates a number of datasets from one metadata scenario
}
\examples{
\dontrun{
source(system.file("dangl2014.R", package="bdlp"))
generateDatabase(name="dangl2014.R", setnr=1, draws=10)
unlink("dangl2014_set_1_seed_100.db")
}
}
