% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{tidy.prop_scr}
\alias{tidy.prop_scr}
\title{Tidy a(n) prop_scr object}
\usage{
\method{tidy}{prop_scr}(x, ...)
}
\arguments{
\item{x}{a \code{prop_scr} obj}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A tidy \code{\link[tibble:tibble]{tibble::tibble()}} summarizing the results of the propensity
score weighting. The tibble will have the id column of the external data,
an \code{internal} column to indicate all the data is external, a \code{ps} column
with the propensity scores and a \code{weight} column with the inverse
probability weights
}
\description{
Tidy a(n) prop_scr object
}
\examples{
library(dplyr)
ps_obj <- calc_prop_scr(internal_df = filter(int_binary_df, trt == 0),
                       external_df = ex_binary_df,
                       id_col = subjid,
                       model = ~ cov1 + cov2 + cov3 + cov4)
tidy(ps_obj)

}
