% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{genus_to_species}
\alias{genus_to_species}
\title{Genus to Species Conversion}
\usage{
genus_to_species(is_genus, count)
}
\arguments{
\item{is_genus}{\code{logical} vector with elements \code{TRUE} if the 
corresponding taxon is on the genus level, and \code{FALSE} if it is on 
the  \code{species} level.}

\item{count}{\code{numeric} vector with elements giving the counts of each
corresponding taxon.}
}
\value{
\code{numeric} vector with updated counts. The counts for the 
     taxon on the genus level have been set to zero.
}
\description{
This algorithm reallocates the counts of taxa, that are only identified at
the genus level to taxa in the same sampling unit and of the same genus 
but that are identified on the species level. The redistribution of counts 
is proportional to the number of counts at the species level.
}
\note{
Parameters \code{is_genus} and \code{count} are of the same length and
     correspond to the same taxon.

The resulting counts are not necessarily integers.
}
\examples{
     genus_to_species(is_genus = c(TRUE, FALSE, FALSE), count = c(3, 10, 20))
     genus_to_species(is_genus = c(TRUE, FALSE, FALSE), count = c(1, 10, 20))
}
