% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{qBetaMS}
\alias{qBetaMS}
\title{Quantile Containing Specific Proportion of the Distribution, Given a Specific Probability of the Beta Probability Density Distribution with Specific Mean and Variance.}
\usage{
qBetaMS(p, mean, variance = NULL, sd = NULL, lower.tail = TRUE, l = 0, u = 1)
}
\arguments{
\item{p}{A value of probability marking the point of the Y-axis to correspond to the X-axis.}

\item{mean}{The mean of the target Standard Beta probability density distribution.}

\item{variance}{The variance of the target Standard Beta probability density distribution.}

\item{sd}{The standard deviation of the target Standard Beta probability density distribution.}

\item{lower.tail}{Logical. Specifies which end of the tail for which to calculate quantile. Default is \code{TRUE} (meaning, find q for lower tail.)}

\item{l}{The lower-bound location parameter. Default set to 0 (the standard Beta distribution).}

\item{u}{The upper-bound location parameter. Default set to 1 (the standard Beta distribution).}
}
\value{
A numeric value representing the quantile for which the specified proportion of observations fall within.
}
\description{
Calculates the quantile corresponding to a specific probability of some observation falling within the [0, x] (\code{lt = TRUE}) or [x, 1] (\code{lt = FALSE}) interval under the Standard Beta probability density distribution with defined mean and variance or standard deviation.
}
\examples{
# To compute the quantile at a specific point (e.g., 0.5) along the Standard
# (two-parameter) Probability Density Distribution with mean of 0.6 and variance of 0.04:
qBetaMS(p = 0.5, mean = 0.6, variance = 0.04)

# To compute the quantile at a specific points(e.g., 0.5) along the four-
# parameter Beta distribution with a mean of 60, variance of 400, and lower-
# bound of 0 and upper-bound of 100:
qBetaMS(p = 0.5, mean = 60, variance = 400, l = 0, u = 100)
}
