% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfsl.R
\name{glance.bfsl}
\alias{glance.bfsl}
\title{Glance at a bfsl Object}
\usage{
\method{glance}{bfsl}(x, ...)
}
\arguments{
\item{x}{A `bfsl` object.}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A [tibble::tibble()] with one row and columns:
\item{chisq}{The goodness of fit.}
\item{p.value}{P-value.}
\item{df.residual}{Residual degrees of freedom.}
\item{nobs}{Number of observations.}
\item{isConv}{Did the fit converge?}
\item{iter}{Number of iterations.}
\item{finTol}{Final tolerance.}
}
\description{
Broom tidier method to \code{glance} at a bfsl object.
}
\examples{
fit = bfsl(pearson_york_data)

glance(fit)

}
