% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc.R
\name{icc}
\alias{icc}
\title{Item Characteristic Curve}
\usage{
icc(a, d, t, from = -3, to = 3, by = 0.01, layout_matrix = 1,
  main_title = "Item Characteristic Curve", sub = "",
  color = "black", plot_responses = FALSE, thetas = NULL,
  responses = NULL, response_color = "#0000005f")
}
\arguments{
\item{a}{A numeric vector of alpha parameters}

\item{d}{A numeric vector of delta parameters}

\item{t}{Either a list of numeric vectors for the tau parameters for each
option, or a numeric vector if the IRF for only one item is desired --
note the first element of each vector should be zero}

\item{from}{A numeric vector of length one,
the lowest theta value to estimate response probabilities for;
default is -3}

\item{to}{A numeric vector of length one,
the highest theta value to estimate response probabilities for;
default is 3}

\item{by}{A numeric vector of length one giving the spacing between
theta values; default is 0.01}

\item{layout_matrix}{An integer matrix dictating the layout of the plot;
the default is a one-column matrix with one element for each item}

\item{main_title}{A character vector giving the plots' main titles;
default is "Item Characteristic Curve".}

\item{sub}{An optional character vector of subtitles for the resulting plots,
to be pasted onto the main title (helpful for titling individual plots
when plotting multiple items' ICCs).}

\item{color}{The color to plot the ICC line in; default is "black"}

\item{plot_responses}{A logical vector of length one specifying whether to
draw points at the theta estimates of actual responses; default is FALSE}

\item{thetas}{An optional vector of theta estimates for response drawing;
if \code{plot_responses = TRUE} and \code{thetas} is not provided,
an error will be thrown.}

\item{responses}{An optional matrix or vector (if the ICC for only one item
is desired) of responses; if \code{plot_responses = TRUE} and
\code{responses} is not provided, an error will be thrown.
NOTE: The lowest response for each item should be 0, not 1.}

\item{response_color}{The color to plot the response points when
\code{plot_responses = TRUE}; the default is \code{"#0000005f"}.}
}
\description{
Plots item characteristic curves given alpha, delta, and tau parameters.
}
\examples{
## We'll simulate data to use for these examples:
set.seed(123)
sim_data <- ggum_simulation(100, 10, 4)
## You can plot the ICC for one item:
icc(sim_data$alpha[1], sim_data$delta[1], sim_data$tau[[1]])
## Or multiple items:
icc(sim_data$alpha[1:2], sim_data$delta[1:2], sim_data$tau[1:2], sub = 1:2)
## You can also plot the actual responses over the expected response line:
icc(sim_data$alpha[1], sim_data$delta[1], sim_data$tau[[1]],
    plot_responses = TRUE, responses = sim_data$response_matrix[ , 1],
    thetas = sim_data$theta)

}
