% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot}
\alias{plot}
\alias{plot.bhetgp}
\alias{plot.bhomgp}
\alias{plot.bhetgp_vec}
\alias{plot.bhomgp_vec}
\title{Plots object from \code{bhetGP} package}
\usage{
\method{plot}{bhetgp}(x, trace = NULL, predict = NULL, verb = TRUE, ...)

\method{plot}{bhomgp}(x, trace = NULL, predict = NULL, verb = TRUE, ...)

\method{plot}{bhetgp_vec}(x, trace = NULL, predict = NULL, verb = TRUE, ...)

\method{plot}{bhomgp_vec}(x, trace = NULL, predict = NULL, verb = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{bhetgp}, \code{bhetgp_vec}, \code{bhomgp}, 
or \code{bhomgp_vec}}

\item{trace}{logical indicating whether to generate trace plots (default is
TRUE if the object has not been through \code{predict})}

\item{predict}{logical indicating whether to generate posterior predictive 
plot (default is TRUE if the object has been through \code{predict})}

\item{verb}{logical indicating whether to print plot.}

\item{...}{N/A}
}
\value{
...N/A
}
\description{
Acts on a \code{bhetgp}, \code{bhetgp_vec}, \code{bhomgp} or,
    \code{bhomgp_vec} object.  Generates trace plots for log likelihood of 
    mean and noise process, length scales of corresponding processes,
    scale parameters and the nuggets.
    Generates plots of hidden layers for one-dimensional inputs. Generates
    plots of the posterior mean and estimated 90\% prediction intervals for 
    one-dimensional inputs; generates heat maps of the posterior mean and 
    point-wise variance for two-dimensional inputs.
}
\details{
Trace plots are useful in assessing burn-in.  If there are too
    many hyperparameters to plot them all, then it is most useful to 
    visualize the log likelihood (e.g., \code{plot(fit$ll, type = "l")}).
}
