% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class035-bids_sessions.R
\name{BIDSTabularSessions}
\alias{BIDSTabularSessions}
\title{'BIDS' sessions table class}
\usage{
BIDSTabularSessions(content, meta = NULL)
}
\arguments{
\item{content, meta}{see \code{\link{BIDSTabular}}}
}
\value{
A \code{BIDSTabularSessions} instance inheriting
\code{\link{BIDSTabular}}.
}
\description{
A tabular containing a list of sessions and their metadata.
The class is a child class of \code{\link{BIDSTabular}}, hence see
the methods there.
The original specification is at
\url{https://bids-specification.readthedocs.io/en/stable/modality-agnostic-files.html#sessions-file}.
}
\examples{



# basic
tabular <- BIDSTabularSessions(data.frame(
  session_id = c("ses-predrug", "ses-postdrug", "ses-followup"),
  acq_time = c(
    "2009-06-15T13:45:30",
    "2009-06-16T13:45:30",
    "2009-06-17T13:45:30"
  ),
  systolic_blood_pressure = c(120, 100, 110)
))
tabular


# convert existing tabular
tabular <- BIDSTabular(
  data.frame(
    acq_time = "2009-06-15T13:45:30",
    session_id = "ses-predrug",
    systolic_blood_pressure = 120
  )
)
tabular <- as_bids_tabular(tabular, cls = BIDSTabularSessions)
tabular


# save to tsv
tsv <- file.path(tempdir(), "sessions.tsv")
paths <- save_bids_tabular(tabular, tsv)

print(paths)


# use base R to read
read.table(tsv, header = TRUE, na.strings = "n/a")

# get sidecar
cat(readLines(paths$sidecar_path), sep = "\n")


# clean up
unlink(tsv)
unlink(paths$sidecar_path)



}
\author{
Zhengjia Wang
}
