% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa-generics-get_bids_entity.R
\name{get_bids_entity}
\alias{get_bids_entity}
\alias{get_bids_entity_rules}
\title{Get 'BIDS' entity values from file}
\usage{
get_bids_entity(x, key, value_only = TRUE, ifnotfound = NULL)

get_bids_entity_rules(x)
}
\arguments{
\item{x}{'BIDS' file path or parsed object; see 'Examples'}

\item{key}{entity key}

\item{value_only}{whether to return the value only; default is true; set
to \code{FALSE} to return the entity object}

\item{ifnotfound}{default value to return is the entity is missing}
}
\value{
'BIDS' entity value or object, depending on \code{value_only}
}
\description{
Get 'BIDS' entity values from file
}
\examples{

# Quick usage
get_bids_entity("ieeg/sub-YAB_ses-01_task-AV_ieeg.mat", "sub")

get_bids_entity_rules("ieeg/sub-YAB_ses-01_task-AV_channels.tsv")

# Full usage
parsed <- parse_path_bids_entity(
    path = "ieeg/sub-YAB_ses-01_task-AV_channels.tsv")

parsed$get_bids_entity("sub")
parsed$get_bids_entity_rules()

parsed$description
parsed$entities

}
\author{
Zhengjia Wang
}
