% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-parapply.R
\name{split_parapply}
\alias{split_parapply}
\title{Split-parApply-Combine}
\usage{
split_parapply(
  FUN,
  ind,
  ...,
  .combine = NULL,
  ncores = nb_cores(),
  nb_split = ncores,
  opts_cluster = list(),
  .costs = NULL
)
}
\arguments{
\item{FUN}{The function to be applied to each subset matrix.}

\item{ind}{Initial vector of indices that will be splitted in \code{nb_split}.}

\item{...}{Extra arguments to be passed to \code{FUN}.}

\item{.combine}{Function to combine the results with \code{do.call}.
This function should accept multiple arguments (using \code{...}). For example,
you can use \code{c}, \code{cbind} and \code{rbind}. This package also provides function
\code{plus} to add multiple arguments together. The default is \code{NULL}, in which
case the results are not combined and are returned as a list, each element
being the result of a block.}

\item{ncores}{Number of cores to use. Default uses \code{nb_cores()}.}

\item{nb_split}{Number of blocks. Default uses \code{ncores}.}

\item{opts_cluster}{Optional parameters for clusters passed as a named list.
E.g., you can use \code{type = "FORK"} to use forks instead of clusters.
You can also use \code{outfile = ""} to redirect printing to the console.}

\item{.costs}{Vector of costs (e.g. proportional to computation time)
associated with each element of \code{ind}. Default is \code{NULL} (same cost).}
}
\value{
Return a list of \code{ncores} elements, each element being the result of
one of the cores, computed on a block. The elements of this list are then
combined with \code{do.call(.combine, .)} if \code{.combined} is not \code{NULL}.
}
\description{
A Split-Apply-Combine strategy to parallelize the evaluation of a function.
}
\details{
This function splits indices in parts, then apply a given function to each
part and finally combine the results.
}
\examples{
\dontrun{

str(
  split_parapply(function(ind) {
    sqrt(ind)
  }, ind = 1:10000, ncores = 2)
)
}

}
