% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theory.R
\name{Theoretical}
\alias{Theoretical}
\alias{is.wholenumber}
\alias{dB}
\alias{undB}
\alias{Q_}
\alias{Q_Inv}
\alias{QPSKdB}
\alias{DQPSKdB}
\alias{DQPSKDDdB}
\alias{PSQPSKdB}
\alias{MPSKdB}
\alias{MPSKdB.8}
\alias{QAMdB.8.star}
\alias{QAMdB}
\alias{QAMdB.16}
\alias{mod_Inv}
\alias{mod_InvV}
\title{Theoretical error rate functions}
\usage{
is.wholenumber(x, tol = sqrt(.Machine$double.eps))

dB(x)

undB(x)

Q_(x)

Q_Inv(perr)

QPSKdB(x)

DQPSKdB(x)

DQPSKDDdB(x)

PSQPSKdB(x)

MPSKdB(x, M)

MPSKdB.8(x)

QAMdB.8.star(x)

QAMdB(x, M)

QAMdB.16(x)

mod_Inv(f, perr, guess = Q_Inv(perr))

mod_InvV(f, pv, offset = 0)
}
\arguments{
\item{x}{a real number}

\item{tol}{the tolerance to test x with.}

\item{perr}{a probability of a bit error.}

\item{M}{The integer number of symbols > 4.}

\item{f}{a function (usually a BER function).}

\item{guess}{a guess for the \code{perr} (the default usually works).}

\item{pv}{a vector of BERs.}

\item{offset}{an offset in Decibels for guesses in \code{mod_InvV}.}
}
\value{
\code{is.wholenumber(x)} returns \code{TRUE} if \code{c-round(x) < tol}.

\code{dB(x)} returns \code{10*log10(x)}

\code{undB(x)} returns \code{10^(x/10)}

\code{Q_Inv(x)} returns \code{2*dB( -qnorm(x))}, which is the
SNR (in Decibels) required to get a probability of error of x.
Q_Inv( Q_( undB( x/2))) = x and Q_( undB( Q_Inv( x)/2))=x

\code{ mod_Inv( f, x)} returns a list with the SNR in Decibels to
reach the BER
\code{perr} such that \code{f( mod_Inv( f, x)$x) = x}.
The returned list has elements
\code{$x} as the SNR and
\code{$fval} as the function value.
}
\description{
Functions to calculate the theoretical performance of common modulation
formats.  Includes the functions \code{dB (x)} (returns \verb{10log10(x)}), \code{undB(x)}
(reverses \code{dB(x)}), \code{Q_( x)} (Markum's Q function), and \code{Q_Inv(x)}
(returns the
SNR in Decibels to get probability x).  Also includes \code{mod_Inv}, which returns
the SNR required for a the function \code{f} to reach the supplied BER (bit
error rate, or bit error probability).
}
\details{
The rest of the functions return the probability of a bit error given the
SNR in Decibels.
\itemize{
\item \code{QPSKdB} is Quadrature Phase shift keyed: two bits per symbol.
\item \code{DQPSK} is differentially detected differentially coded QPSK.
\item \code{DQPSKDDdB} is differentially detected differential QPSK (coherently
detected but differentially decoded. See \code{DQPSK} above.
\item \code{PSQPSKdB} is polarization-shifted QPSK: it is dual pole, but only
one pole is active at any one time, thus supplying three bits per
symbol. (See Agrell & Karlsson (2009, DOI:10.1109/JLT.2009.2029064)).
\item \code{MPSKdB(x, M)} is generic M-ary phase shift keying of \code{M} points in a circle.
\item \code{MPSKdB.8} simply returns \code{MPSKdB(x, 8)}
\item \code{QAMdB.8.star} is the optimal star configuration of 8-ary Quadrature
Amplitude Modulation (QAM), such that
the legs are at \eqn{\pm1} and \eqn{\pm(1+\sqrt3)}.
\item \code{QAMdB(x, M)} is generic rectangular QAM constellation of \code{M} points.
\item \code{QAMdB.16} Returns the BER for the rectangular QAM constellation according to
Proakis Eq. 5-2-80.
\item \code{mod_Inv} will take a function \code{f(x)} and return the x such that
\code{f(x)==perr}
but it does this based on the \code{log( f(x))} and the \code{log( perr)}, so
\code{f(x)>0}.
\item \code{mod_InvV} is a vectorized version (give it a vector of BERs and it returns a
vector of SNRs).
}
}
\examples{
dB( 10) # == 10
undB( 20) # == 100
Q_Inv( Q_( undB( 10/2))) # = 10
Q_( undB( Q_Inv( 0.001)/2)) # = 0.001

mod_Inv( QPSKdB, QPSKdB( 7)) # yields 7

mod_InvV(QPSKdB, QPSKdB(c(6,7)))

}
\seealso{
\code{\link[pracma:fzero]{pracma::fzero()}}
}
