% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-bytes.R
\name{bits_to_raw}
\alias{bits_to_raw}
\alias{raw_to_bits}
\title{Convert between logical vector of bits and raw vector}
\usage{
bits_to_raw(bits, msb_first = TRUE)

raw_to_bits(x, msb_first = TRUE)
}
\arguments{
\item{bits}{Logical vector of bit values. Length must be a multiple of 8}

\item{msb_first}{MSB first? Default: TRUE}

\item{x}{Byte values. Integer vectors will be truncated to 8 bits
before output.  Numeric vectors will be rounded to integers and then 
truncated to 8 bits.  Raw vectors preferred.}
}
\value{
Logical vector of bit values or a raw vector.
}
\description{
Convert between logical vector of bits and raw vector
}
\examples{
bits <- raw_to_bits(c(0, 4, 21))
bits
bits_to_raw(bits) |> as.integer()
}
