% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-bytes.R
\name{bs_write_byte}
\alias{bs_write_byte}
\alias{bs_read_byte}
\title{Read/Write unaligned bytes with a bitstream}
\usage{
bs_write_byte(bs, x)

bs_read_byte(bs, n)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{x}{vector of bytes to write.  Integer vectors will be truncated to 8 bits
before output.  Numeric vectors will be rounded to integers and then 
truncated to 8 bits.}

\item{n}{number of bytes to read}
}
\value{
Reading returns a logical vector of bit values.  When writing, 
the \code{bs} 
bitstream connection is returned invisibly
}
\description{
Read/Write unaligned bytes with a bitstream
}
\examples{
bs  <- bs_open(raw(), 'w')
bs_write_bit(bs, c(TRUE, FALSE))
bs_write_byte(bs, c(1, 2, 3))
bs_align(bs)
raw_vec <- bs_close(bs)

bs  <- bs_open(raw_vec, 'r')
bs_read_bit(bs, 2)
bs_read_byte(bs, 3)
bs_close(bs)

}
