% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcPIPs.R
\name{ExtractPIPs}
\alias{ExtractPIPs}
\title{Extract posterior inclusion probabilities (PIPs) from BKMR model fit}
\usage{
ExtractPIPs(fit, sel = NULL, z.names = NULL)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{z.names}{optional argument providing the names of the variables included in the \code{h} function.}
}
\value{
a data frame with the variable-specific PIPs for BKMR fit with component-wise variable selection, and with the group-specific and conditional (within-group) PIPs for BKMR fit with hierarchical variable selection.
}
\description{
Extract posterior inclusion probabilities (PIPs) from Bayesian Kernel Machine Regression (BKMR) model fit
}
\details{
For guided examples, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)

ExtractPIPs(fitkm)
}
