% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_statistics.R
\docType{class}
\name{FarringtonManning-class}
\alias{FarringtonManning-class}
\alias{FarringtonManning}
\alias{setupFarringtonManning}
\title{Farrington Manning test}
\usage{
setupFarringtonManning(alpha, beta, r = 1, delta, delta_NI, n_max = Inf, ...)
}
\arguments{
\item{alpha}{One-sided type I error rate.}

\item{beta}{Type II error rate.}

\item{r}{Allocation ratio between experimental and control group.}

\item{delta}{Difference of effect size between alternative and null hypothesis.}

\item{delta_NI}{Non-inferiority margin.}

\item{n_max}{Maximal overall sample size. If the recalculated sample size
is greater than \code{n_max} it is set to \code{n_max}.}

\item{...}{Further optional arguments.}
}
\value{
An object of class \code{\link{FarringtonManning}}.
}
\description{
This class implements a Farrington-Manning test for non-inferiority
trials. A trial with binary outcomes in two groups \code{E} and
\code{C} is assumed. The null and alternative hypotheses for the
non-inferiority of response probabilities are:
\deqn{H_0: p_E - p_C \leq -\delta \textrm{ vs. } H_1: p_E - p_C > -\delta,}
where \eqn{\delta} denotes the non-inferiority margin.

The function \code{\link{setupFarringtonManning}} creates an object of
\code{\link{FarringtonManning}}.
}
\details{
The nuisance parameter is the overall response probability \eqn{p_0}.
In the blinded sample size recalculation procedure it is blindly estimated
by:
\deqn{\hat{p}_0 := (X_{1,E} + X_{1,C}) / (n_{1,E} + n_{1,C}),}
where
\eqn{X_{1,E}} and \eqn{X_{1,C}} are the numbers of responses and \eqn{n_{1,E}}
and \eqn{n_{1,C}} are the sample sizes of the respective group after the first stage.
The event rates in both groups under the alternative hypothesis can then be
blindly estimated as:
\deqn{\hat{p}_{C,A} := \hat{p}_0 - \Delta \cdot r / (1 + r) \textrm{, }
\hat{p}_{E,A} := \hat{p}_0 + \Delta / (1 + r),}
where \eqn{\Delta} is the difference in
response probabilities under the alternative hypothesis and r is the
allocation ratio of the sample sizes in the two groups.
These blinded estimates can then be used to re-estimate the sample
size.
}
\examples{
design <- setupFarringtonManning(alpha = .025, beta = .2, r = 1, delta = 0,
delta_NI = .15)

}
\references{
Friede, T., Mitchell, C., & Mueller-Velten, G. (2007). Blinded sample size
reestimation in non-inferiority trials with binary endpoints.
Biometrical Journal, 49(6), 903-916. \cr
Kieser, M. (2020). Methods and applications of sample size calculation and
recalculation in clinical trials. Springer.
}
