% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeGibbs.R
\name{mpmms}
\alias{mpmms}
\title{Function to compute a record's MPMMS based on a Gibbs sampler. Note: It returns a list of the MPMMS ($mpmms) and its probability ($prob)}
\usage{
mpmms(lam.gs, record)
}
\arguments{
\item{lam.gs}{The gibbs sampler}

\item{record}{A specific record}
}
\value{
Returns a list of the MPMSS and the associated probabilities.
}
\description{
Function to compute a record's MPMMS based on a Gibbs sampler. Note: It returns a list of the MPMMS ($mpmms) and its probability ($prob)
}
\examples{
lam.gs <- matrix(c(1,1,2,2,3,3,5,6,4,3,4,5,3,2,4,1,2,3,4,2),ncol=20,  nrow=4)
record <- c(1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3)
mpmms(lam.gs=lam.gs, record=record)
}
