% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block-meta.R
\name{blks_metadata}
\alias{blks_metadata}
\alias{blk_color}
\alias{blk_icon_data_uri}
\title{Get block metadata}
\usage{
blks_metadata(blocks)

blk_color(category)

blk_icon_data_uri(icon_svg, color, size = 48, mode = c("uri", "inline"))
}
\arguments{
\item{blocks}{Blocks passed as \code{blocks} or \code{block} object}

\item{category}{Block category}

\item{icon_svg}{Character string containing the SVG icon markup}

\item{color}{Hex color code for the background}

\item{size}{Numeric size in pixels (default: 48)}

\item{mode}{Switch between URI and inline HTML mode}
}
\value{
Metadata is returned from \code{blks_metadata()} as a \code{data.frame} with
each row corresponding to a block. Both \code{blk_color()} and
\code{blk_icon_data_uri()} return character vectors.
}
\description{
Returns various metadata for blocks or block categories, as well as styling
for block icons.
}
\details{
\itemize{
\item \code{blks_metadata()}: Retrieves metadata given a \code{block} or \code{blocks} object
from the block registry. Can also handle blocks which are not
registered and provides default values in that case.
\item \code{blk_color()}: Produces colors using the Okabe-Ito colorblind-friendly
palette for a character vector of block categories.
\item \code{blk_icon_data_uri()}: Processes block icons to add color and turn them
into square-shaped icons.
}
}
\examples{
blk <- blockr.core::new_dataset_block()
meta <- blks_metadata(blk)

col <- blk_color(meta$category)
blk_icon_data_uri(meta$icon, col)

}
