% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{vb_summary}
\alias{vb_summary}
\alias{vb_uncertainty}
\title{Summarize uncertainty for a vbdf objects}
\usage{
vb_summary(
  object,
  type = c("discrete", "continuous", "binned"),
  estimates = grep("prob|pr_turnout|pr_votedem|pr_voterep|cond_rep|net_rep",
    names(object), value = TRUE),
  na.rm = FALSE,
  funcs = c("mean", "median", "low", "high"),
  low_ci = 0.025,
  high_ci = 0.975,
  bin_col,
  tolerance = sqrt(.Machine$double.eps)
)

vb_uncertainty(
  object,
  type = c("discrete", "continuous", "binned"),
  estimates = grep("prob|pr_turnout|pr_votedem|pr_voterep|cond_rep|net_rep",
    names(object), value = TRUE),
  na.rm = FALSE,
  funcs = c("mean", "median", "low", "high"),
  low_ci = 0.025,
  high_ci = 0.975,
  bin_col,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{object}{a \code{vbdf} object, usually the output of [vb_discrete], [vb_continuous], or [vb_difference].}

\item{type}{a string naming the type of independent variable summary. Use
\code{"binned"} when using the output of [vb_continuous] plus a binned version of the continuous bloc variable.}

\item{estimates}{character vector naming columns for which to calculate
uncertainty estimates.}

\item{na.rm}{logical indicating whether to remove \code{NA} values in
\code{estimates}.}

\item{funcs}{character vector of summary functions to apply to
\code{estimates}. Alternatively, supply your own list of functions, which
should accept a numeric vector input and return a scalar.}

\item{low_ci}{numeric. If you include the string \code{"low"} in \code{funcs}, then use this argument to control the lower bound of the confidence interval.}

\item{high_ci}{numeric. If you include the string \code{"high"} in \code{funcs}, then use this argument to control the upper bound of the confidence interval.}

\item{bin_col}{character vector naming the column(s) that define the bins. Used only when  \code{type} is \code{"binned"}.}

\item{tolerance}{tolerance used when checking range of probability estimates}
}
\value{
A summary object with additional columns for each combination
  of \code{estimates} and \code{funcs}.
}
\description{
Summarize uncertainty for a vbdf objects. Analysis must have run with bootstrap iterations.
\code{vb_uncertainty} is just an alias for \code{vb_summary}.
}
