% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_n_series}
\alias{get_n_series}
\title{Create and execute a query to retrieve one or more time series and their
catalog data}
\usage{
get_n_series(
  series_ids,
  api_key = bls_get_key(),
  start_year = NULL,
  end_year = NULL,
  year_limit = NULL,
  span = TRUE,
  catalog = FALSE,
  calculations = FALSE,
  annualaverage = FALSE,
  aspects = FALSE,
  series_limit = NULL,
  ...
)
}
\arguments{
\item{series_ids}{a list or character vector of BLS time-series IDs. If the
items are named then the names will be used in the returned list}

\item{api_key}{Optional. An API key string. Defaults to the value returned by
\code{\link[=bls_get_key]{bls_get_key()}}. The preferred way to provide an API key is to use
\code{\link[=bls_set_key]{bls_set_key()}} or the \code{BLS_API_KEY} environment variable. Manually passing
the key will be deprecated in future releases.}

\item{start_year, end_year}{numeric 4-digit years. While optional, they are
strongly recommended. If one is provided, the other is mandatory. \code{end_year}
must be greater than \code{start_year}}

\item{year_limit}{optional number of years to paginate request by. If not
explicitly set, it will be set to 10 or 20 depending on if an \code{api_key} is
available}

\item{span}{when set to \code{TRUE}, requests where the number of years between
\code{start_year} and \code{end_year} exceed \code{year_limit} will be performed as
multiple requests automatically}

\item{catalog}{boolean. If set to \code{TRUE}, element item in the list returned
may include a named item \code{catalog}, a named list containing descriptive
information about the series. Not all series have a catalog entry
available.}

\item{calculations}{boolean. If set to \code{TRUE}, each element in the \code{data}
list for each series returned may include an additional named element
\code{calculations}, a named list containing two items, \code{net_changes} and
\code{pct_changes}, each of them a named list which may include items \code{1}, \code{3},
\code{6}, \code{12} which represent 1, 3, 6, and 12 month net changes and percent
changes respectively. Not all data series will have enough data points to
include these calculations.}

\item{annualaverage}{boolean. If set to \code{TRUE}, each \code{data} list may include
an additional element for a an annual average of the time series, which is
usually presented as month 13 in monthly data. Not all data series
support this feature.}

\item{aspects}{boolean. If set to \code{TRUE}, each item in the \code{data} list
for each series returned may include an additional named element \code{aspects},
which will be a named list. Not all data series support this feature.}

\item{series_limit}{Maximum number of series to request in one API call
when \code{span} is set to \code{TRUE}.}

\item{...}{additional arguments to pass to \code{\link[=bls_request]{bls_request()}}}
}
\value{
a list of series results. Each element of the returned list is
a named list guaranteed to have two items, \code{SeriesID} and \code{data} and
optionally \code{catalog}. The unnamed list \code{data} will have 0 or more elements,
each one a named list representing an observation in the time series. Each
observation is guaranteed to include the elements \code{year}, \code{period},
\code{periodName}, \code{value}, and \code{footnotes}. Footnotes are a list of named lists.
The rest are scalar values. If the the most recent observation is included,
that observation will have an element named \code{latest} which will contain the
text '\code{true}'. If \code{calculations} or \code{aspects} were requested they will be
present as named elements in each observation.
}
\description{
Create and execute a query to retrieve one or more time series and their
catalog data
}
\examples{
\dontrun{
series_ids <- list(uer.men ='LNS14000001', uer.women = 'LNS14000002')
uer_series <- get_n_series(series_ids, 'your-api-key-here' )
}
}
\seealso{
\code{\link{query_n_series}}

Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_series_request}()}
}
\concept{blsR-requests}
