% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_series}
\alias{get_series}
\title{Create and execute query for a single time series}
\usage{
get_series(
  series_id,
  start_year = NULL,
  end_year = NULL,
  year_limit = NULL,
  span = TRUE,
  api_key = bls_get_key(),
  ...
)
}
\arguments{
\item{series_id}{Character scalar BLS series ID}

\item{start_year, end_year}{numeric 4-digit years. While optional, they are
strongly recommended. If one is provided, the other is mandatory. \code{end_year}
must be greater than \code{start_year}}

\item{year_limit}{optional number of years to paginate request by. If not
explicitly set, it will be set to 10 or 20 depending on if an \code{api_key} is
available}

\item{span}{when set to \code{TRUE}, requests where the number of years between
\code{start_year} and \code{end_year} exceed \code{year_limit} will be performed as
multiple requests automatically}

\item{api_key}{Optional. An API key string. Defaults to the value returned by
\code{\link[=bls_get_key]{bls_get_key()}}. The preferred way to provide an API key is to use
\code{\link[=bls_set_key]{bls_set_key()}} or the \code{BLS_API_KEY} environment variable. Manually passing
the key will be deprecated in future releases.}

\item{...}{additional arguments to pass to \code{\link[=bls_request]{bls_request()}}}
}
\value{
a single series result, in list form. The resulting list will have
the following items:
\itemize{
\item \code{seriesID}: a character vector of length 1 containing the \code{series_id}
\item \code{data}: a list of lists containing the payload data. Each item of the list
represents an observation. Each observation is a list with the following
named items \code{year}, \code{period}, \code{periodName}, \code{value}, \code{footnotes}.
Footnotes are a list. Additionally, the most recent observation will have
an item named \code{latest} which will be marked as 'true'.
}
}
\description{
Create and execute query for a single time series
}
\examples{
\dontrun{
series <- get_series('LNS14000001')
}
}
\seealso{
\code{\link{query_series}}

Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_survey_info}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_series_request}()}
}
\concept{blsR-requests}
