% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{query_n_series}
\alias{query_n_series}
\title{Create a query to retrieve one or more time series and their catalog data}
\usage{
query_n_series(
  series_ids,
  start_year = NULL,
  end_year = NULL,
  catalog = FALSE,
  calculations = FALSE,
  annualaverage = FALSE,
  aspects = FALSE
)
}
\arguments{
\item{series_ids}{Character vector of BLS series IDs}

\item{start_year, end_year}{numeric 4-digit years. While optional, they are
strongly recommended. If one is provided, the other is mandatory. \code{end_year}
must be greater than \code{start_year}}

\item{catalog}{boolean. If set to \code{TRUE}, element item in the list returned
may include a named item \code{catalog}, a named list containing descriptive
information about the series. Not all series have a catalog entry
available.}

\item{calculations}{boolean. If set to \code{TRUE}, each element in the \code{data}
list for each series returned may include an additional named element
\code{calculations}, a named list containing two items, \code{net_changes} and
\code{pct_changes}, each of them a named list which may include items \code{1}, \code{3},
\code{6}, \code{12} which represent 1, 3, 6, and 12 month net changes and percent
changes respectively. Not all data series will have enough data points to
include these calculations.}

\item{annualaverage}{boolean. If set to \code{TRUE}, each \code{data} list may include
an additional element for a an annual average of the time series, which is
usually presented as month 13 in monthly data. Not all data series
support this feature.}

\item{aspects}{boolean. If set to \code{TRUE}, each item in the \code{data} list
for each series returned may include an additional named element \code{aspects},
which will be a named list. Not all data series support this feature.}
}
\value{
list of query parameters
}
\description{
Create a query to retrieve one or more time series and their catalog data
}
\examples{

a <- query_n_series(c('LNS14000001', 'LNS14000002'))
b <- query_n_series(c('LNS14000001', 'LNS14000002'), start_year = 2005, end_year=2010)
c <- query_n_series(c('LNS14000001', 'LNS14000002'), 2005, 2010)
d <- query_n_series(c('LNS14000001', 'LNS14000002'), catalog=TRUE)


}
\seealso{
Other blsR-queries: 
\code{\link{query_all_surveys}()},
\code{\link{query_latest_observation}()},
\code{\link{query_popular_series}()},
\code{\link{query_series}()},
\code{\link{query_survey_info}()},
\code{\link{span_request_queries}()}
}
\concept{blsR-queries}
