% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_request.R
\name{span_series_request}
\alias{span_series_request}
\title{Break up a long request into multiple API calls}
\usage{
span_series_request(start_year, end_year, year_limit, query_fn, ...)
}
\arguments{
\item{start_year, end_year}{numeric 4-digit years. While optional, they are
strongly recommended. If one is provided, the other is mandatory. \code{end_year}
must be greater than \code{start_year}}

\item{year_limit}{positive integer}

\item{query_fn}{a function or closure that takes two arguments, \code{start_year}
and \code{end_year}, and returns a query (see \code{\link[purrr:partial]{purrr::partial()}})}

\item{...}{additional arguments to pass to  \code{\link[=bls_request]{bls_request()}}}
}
\value{
a list of API responses (what comes back from bls_re)
}
\description{
Break up a long request into multiple API calls
}
\seealso{
Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()},
\code{\link{reduce_spanned_responses}()}

Other blsR-utils: 
\code{\link{bls-api-key}},
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_request_queries}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}
}
\concept{blsR-requests}
\concept{blsR-utils}
