// Generated by rstantools.  Do not edit by hand.

/*
    bmggum is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmggum is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmggum.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_UM7withcov_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_UM7withcov");
    reader.add_event(134, 132, "end", "model_UM7withcov");
    return reader;
}
template <typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__>::type
GGUM(const int& y,
         const T1__& theta,
         const T2__& alpha,
         const T3__& delta,
         const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& tau,
         const int& K,
         const int& M, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 8;
        validate_non_negative_index("prob", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> prob(K);
        stan::math::initialize(prob, DUMMY_VAR__);
        stan::math::fill(prob, DUMMY_VAR__);
        current_statement_begin__ = 10;
        validate_non_negative_index("nominator", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> nominator(K);
        stan::math::initialize(nominator, DUMMY_VAR__);
        stan::math::fill(nominator, DUMMY_VAR__);
        current_statement_begin__ = 12;
        for (int a = 1; a <= K; ++a) {
            current_statement_begin__ = 14;
            stan::model::assign(nominator, 
                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                        (stan::math::exp((alpha * (((a - 1) * (theta - delta)) - sum(stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_min_max(1, a), stan::model::nil_index_list()), "tau"))))) + stan::math::exp((alpha * (((M - a) * (theta - delta)) - sum(stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_min_max(1, a), stan::model::nil_index_list()), "tau")))))), 
                        "assigning variable nominator");
        }
        current_statement_begin__ = 18;
        stan::math::assign(prob, divide(nominator, sum(nominator)));
        current_statement_begin__ = 20;
        return stan::math::promote_scalar<fun_return_scalar_t__>(categorical_log(y, prob));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct GGUM_functor__ {
    template <typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__>::type
    operator()(const int& y,
         const T1__& theta,
         const T2__& alpha,
         const T3__& delta,
         const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& tau,
         const int& K,
         const int& M, std::ostream* pstream__) const {
        return GGUM(y, theta, alpha, delta, tau, K, M, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_UM7withcov
  : public stan::model::model_base_crtp<model_UM7withcov> {
private:
        int K;
        int M;
        int I;
        int J;
        int N;
        int I_ne;
        int I_nu;
        int I_po;
        int I_NN;
        int N_mis;
        std::vector<int> II;
        std::vector<int> JJ;
        std::vector<int> y;
        double ma;
        double va;
        double mdne;
        double mdnu;
        double mdpo;
        double vd;
        vector_d mt;
        double vt;
        int trait;
        std::vector<int> ind;
        vector_d theta_mu;
        int P;
        matrix_d PC1;
public:
    model_UM7withcov(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_UM7withcov(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_UM7withcov_namespace::model_UM7withcov";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 2);
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "I", "int", context__.to_vec());
            I = int(0);
            vals_i__ = context__.vals_i("I");
            pos__ = 0;
            I = vals_i__[pos__++];
            check_greater_or_equal(function__, "I", I, 1);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "I_ne", "int", context__.to_vec());
            I_ne = int(0);
            vals_i__ = context__.vals_i("I_ne");
            pos__ = 0;
            I_ne = vals_i__[pos__++];
            check_greater_or_equal(function__, "I_ne", I_ne, 1);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "I_nu", "int", context__.to_vec());
            I_nu = int(0);
            vals_i__ = context__.vals_i("I_nu");
            pos__ = 0;
            I_nu = vals_i__[pos__++];
            check_greater_or_equal(function__, "I_nu", I_nu, 0);
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "I_po", "int", context__.to_vec());
            I_po = int(0);
            vals_i__ = context__.vals_i("I_po");
            pos__ = 0;
            I_po = vals_i__[pos__++];
            check_greater_or_equal(function__, "I_po", I_po, 1);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "I_NN", "int", context__.to_vec());
            I_NN = int(0);
            vals_i__ = context__.vals_i("I_NN");
            pos__ = 0;
            I_NN = vals_i__[pos__++];
            check_greater_or_equal(function__, "I_NN", I_NN, 1);
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "N_mis", "int", context__.to_vec());
            N_mis = int(0);
            vals_i__ = context__.vals_i("N_mis");
            pos__ = 0;
            N_mis = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_mis", N_mis, 0);
            current_statement_begin__ = 35;
            validate_non_negative_index("II", "N", N);
            context__.validate_dims("data initialization", "II", "int", context__.to_vec(N));
            II = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("II");
            pos__ = 0;
            size_t II_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < II_k_0_max__; ++k_0__) {
                II[k_0__] = vals_i__[pos__++];
            }
            size_t II_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < II_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "II[i_0__]", II[i_0__], 1);
                check_less_or_equal(function__, "II[i_0__]", II[i_0__], I);
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("JJ", "N", N);
            context__.validate_dims("data initialization", "JJ", "int", context__.to_vec(N));
            JJ = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("JJ");
            pos__ = 0;
            size_t JJ_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < JJ_k_0_max__; ++k_0__) {
                JJ[k_0__] = vals_i__[pos__++];
            }
            size_t JJ_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < JJ_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "JJ[i_0__]", JJ[i_0__], 1);
                check_less_or_equal(function__, "JJ[i_0__]", JJ[i_0__], J);
            }
            current_statement_begin__ = 37;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            y = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
                check_less_or_equal(function__, "y[i_0__]", y[i_0__], 6);
            }
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "ma", "double", context__.to_vec());
            ma = double(0);
            vals_r__ = context__.vals_r("ma");
            pos__ = 0;
            ma = vals_r__[pos__++];
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "va", "double", context__.to_vec());
            va = double(0);
            vals_r__ = context__.vals_r("va");
            pos__ = 0;
            va = vals_r__[pos__++];
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "mdne", "double", context__.to_vec());
            mdne = double(0);
            vals_r__ = context__.vals_r("mdne");
            pos__ = 0;
            mdne = vals_r__[pos__++];
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "mdnu", "double", context__.to_vec());
            mdnu = double(0);
            vals_r__ = context__.vals_r("mdnu");
            pos__ = 0;
            mdnu = vals_r__[pos__++];
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "mdpo", "double", context__.to_vec());
            mdpo = double(0);
            vals_r__ = context__.vals_r("mdpo");
            pos__ = 0;
            mdpo = vals_r__[pos__++];
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "vd", "double", context__.to_vec());
            vd = double(0);
            vals_r__ = context__.vals_r("vd");
            pos__ = 0;
            vd = vals_r__[pos__++];
            current_statement_begin__ = 46;
            validate_non_negative_index("mt", "K", K);
            context__.validate_dims("data initialization", "mt", "vector_d", context__.to_vec(K));
            mt = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("mt");
            pos__ = 0;
            size_t mt_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < mt_j_1_max__; ++j_1__) {
                mt(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "mt", mt, -(5));
            check_less_or_equal(function__, "mt", mt, 0);
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "vt", "double", context__.to_vec());
            vt = double(0);
            vals_r__ = context__.vals_r("vt");
            pos__ = 0;
            vt = vals_r__[pos__++];
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "trait", "int", context__.to_vec());
            trait = int(0);
            vals_i__ = context__.vals_i("trait");
            pos__ = 0;
            trait = vals_i__[pos__++];
            check_greater_or_equal(function__, "trait", trait, 1);
            check_less_or_equal(function__, "trait", trait, I);
            current_statement_begin__ = 50;
            validate_non_negative_index("ind", "N", N);
            context__.validate_dims("data initialization", "ind", "int", context__.to_vec(N));
            ind = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("ind");
            pos__ = 0;
            size_t ind_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < ind_k_0_max__; ++k_0__) {
                ind[k_0__] = vals_i__[pos__++];
            }
            size_t ind_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < ind_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ind[i_0__]", ind[i_0__], 1);
                check_less_or_equal(function__, "ind[i_0__]", ind[i_0__], I);
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("theta_mu", "trait", trait);
            context__.validate_dims("data initialization", "theta_mu", "vector_d", context__.to_vec(trait));
            theta_mu = Eigen::Matrix<double, Eigen::Dynamic, 1>(trait);
            vals_r__ = context__.vals_r("theta_mu");
            pos__ = 0;
            size_t theta_mu_j_1_max__ = trait;
            for (size_t j_1__ = 0; j_1__ < theta_mu_j_1_max__; ++j_1__) {
                theta_mu(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 53;
            validate_non_negative_index("PC1", "(trait * J)", (trait * J));
            validate_non_negative_index("PC1", "P", P);
            context__.validate_dims("data initialization", "PC1", "matrix_d", context__.to_vec((trait * J),P));
            PC1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((trait * J), P);
            vals_r__ = context__.vals_r("PC1");
            pos__ = 0;
            size_t PC1_j_2_max__ = P;
            size_t PC1_j_1_max__ = (trait * J);
            for (size_t j_2__ = 0; j_2__ < PC1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < PC1_j_1_max__; ++j_1__) {
                    PC1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 58;
            validate_non_negative_index("alpha", "I", I);
            num_params_r__ += I;
            current_statement_begin__ = 59;
            validate_non_negative_index("delta_po", "I_po", I_po);
            num_params_r__ += I_po;
            current_statement_begin__ = 60;
            validate_non_negative_index("delta_ng", "I_ne", I_ne);
            num_params_r__ += I_ne;
            current_statement_begin__ = 61;
            validate_non_negative_index("delta_nu", "I_nu", I_nu);
            num_params_r__ += I_nu;
            current_statement_begin__ = 62;
            validate_non_negative_index("tau_raw", "(K - 1)", (K - 1));
            num_params_r__ += (K - 1);
            current_statement_begin__ = 64;
            validate_non_negative_index("theta", "trait", trait);
            validate_non_negative_index("theta", "J", J);
            num_params_r__ += (trait * J);
            current_statement_begin__ = 65;
            validate_non_negative_index("L_Omega", "trait", trait);
            validate_non_negative_index("L_Omega", "trait", trait);
            num_params_r__ += ((trait * (trait - 1)) / 2);
            current_statement_begin__ = 66;
            validate_non_negative_index("lambda", "P", P);
            validate_non_negative_index("lambda", "trait", trait);
            num_params_r__ += (P * trait);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_UM7withcov() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 58;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "I", I);
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec(I));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha(I);
        size_t alpha_j_1_max__ = I;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            alpha(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 4, alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 59;
        if (!(context__.contains_r("delta_po")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta_po missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta_po");
        pos__ = 0U;
        validate_non_negative_index("delta_po", "I_po", I_po);
        context__.validate_dims("parameter initialization", "delta_po", "vector_d", context__.to_vec(I_po));
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta_po(I_po);
        size_t delta_po_j_1_max__ = I_po;
        for (size_t j_1__ = 0; j_1__ < delta_po_j_1_max__; ++j_1__) {
            delta_po(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 5, delta_po);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta_po: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 60;
        if (!(context__.contains_r("delta_ng")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta_ng missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta_ng");
        pos__ = 0U;
        validate_non_negative_index("delta_ng", "I_ne", I_ne);
        context__.validate_dims("parameter initialization", "delta_ng", "vector_d", context__.to_vec(I_ne));
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta_ng(I_ne);
        size_t delta_ng_j_1_max__ = I_ne;
        for (size_t j_1__ = 0; j_1__ < delta_ng_j_1_max__; ++j_1__) {
            delta_ng(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(5), 0, delta_ng);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta_ng: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 61;
        if (!(context__.contains_r("delta_nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta_nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta_nu");
        pos__ = 0U;
        validate_non_negative_index("delta_nu", "I_nu", I_nu);
        context__.validate_dims("parameter initialization", "delta_nu", "vector_d", context__.to_vec(I_nu));
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta_nu(I_nu);
        size_t delta_nu_j_1_max__ = I_nu;
        for (size_t j_1__ = 0; j_1__ < delta_nu_j_1_max__; ++j_1__) {
            delta_nu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(5), 5, delta_nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta_nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 62;
        if (!(context__.contains_r("tau_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau_raw");
        pos__ = 0U;
        validate_non_negative_index("tau_raw", "(K - 1)", (K - 1));
        context__.validate_dims("parameter initialization", "tau_raw", "vector_d", context__.to_vec((K - 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_raw((K - 1));
        size_t tau_raw_j_1_max__ = (K - 1);
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            tau_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(5), 0, tau_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 64;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "trait", trait);
        validate_non_negative_index("theta", "J", J);
        context__.validate_dims("parameter initialization", "theta", "vector_d", context__.to_vec(J,trait));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > theta(J, Eigen::Matrix<double, Eigen::Dynamic, 1>(trait));
        size_t theta_j_1_max__ = trait;
        size_t theta_k_0_max__ = J;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                theta[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t theta_i_0_max__ = J;
        for (size_t i_0__ = 0; i_0__ < theta_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(theta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 65;
        if (!(context__.contains_r("L_Omega")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable L_Omega missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("L_Omega");
        pos__ = 0U;
        validate_non_negative_index("L_Omega", "trait", trait);
        validate_non_negative_index("L_Omega", "trait", trait);
        context__.validate_dims("parameter initialization", "L_Omega", "matrix_d", context__.to_vec(trait,trait));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> L_Omega(trait, trait);
        size_t L_Omega_j_2_max__ = trait;
        size_t L_Omega_j_1_max__ = trait;
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                L_Omega(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(L_Omega);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable L_Omega: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 66;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "P", P);
        validate_non_negative_index("lambda", "trait", trait);
        context__.validate_dims("parameter initialization", "lambda", "matrix_d", context__.to_vec(P,trait));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> lambda(P, trait);
        size_t lambda_j_2_max__ = trait;
        size_t lambda_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                lambda(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 58;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.vector_lub_constrain(0, 4, I, lp__);
            else
                alpha = in__.vector_lub_constrain(0, 4, I);
            current_statement_begin__ = 59;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_po;
            (void) delta_po;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_po = in__.vector_lub_constrain(0, 5, I_po, lp__);
            else
                delta_po = in__.vector_lub_constrain(0, 5, I_po);
            current_statement_begin__ = 60;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_ng;
            (void) delta_ng;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_ng = in__.vector_lub_constrain(-(5), 0, I_ne, lp__);
            else
                delta_ng = in__.vector_lub_constrain(-(5), 0, I_ne);
            current_statement_begin__ = 61;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_nu;
            (void) delta_nu;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_nu = in__.vector_lub_constrain(-(5), 5, I_nu, lp__);
            else
                delta_nu = in__.vector_lub_constrain(-(5), 5, I_nu);
            current_statement_begin__ = 62;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau_raw;
            (void) tau_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_raw = in__.vector_lub_constrain(-(5), 0, (K - 1), lp__);
            else
                tau_raw = in__.vector_lub_constrain(-(5), 0, (K - 1));
            current_statement_begin__ = 64;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > theta;
            size_t theta_d_0_max__ = J;
            theta.reserve(theta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta.push_back(in__.vector_constrain(trait, lp__));
                else
                    theta.push_back(in__.vector_constrain(trait));
            }
            current_statement_begin__ = 65;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L_Omega;
            (void) L_Omega;  // dummy to suppress unused var warning
            if (jacobian__)
                L_Omega = in__.cholesky_factor_corr_constrain(trait, lp__);
            else
                L_Omega = in__.cholesky_factor_corr_constrain(trait);
            current_statement_begin__ = 66;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.matrix_constrain(P, trait, lp__);
            else
                lambda = in__.matrix_constrain(P, trait);
            // transformed parameters
            current_statement_begin__ = 71;
            validate_non_negative_index("delta1", "I_NN", I_NN);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta1(I_NN);
            stan::math::initialize(delta1, DUMMY_VAR__);
            stan::math::fill(delta1, DUMMY_VAR__);
            current_statement_begin__ = 72;
            validate_non_negative_index("delta", "I", I);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta(I);
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 73;
            validate_non_negative_index("tau", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau(K);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 75;
            stan::math::assign(delta1, append_row(delta_ng, delta_nu));
            current_statement_begin__ = 76;
            stan::math::assign(delta, append_row(delta1, delta_po));
            current_statement_begin__ = 80;
            stan::model::assign(tau, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable tau");
            current_statement_begin__ = 83;
            for (int d = 2; d <= K; ++d) {
                current_statement_begin__ = 85;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                            get_base1(tau_raw, (d - 1), "tau_raw", 1), 
                            "assigning variable tau");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 71;
            size_t delta1_j_1_max__ = I_NN;
            for (size_t j_1__ = 0; j_1__ < delta1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(delta1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 72;
            size_t delta_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(delta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 73;
            size_t tau_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tau(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            {
            current_statement_begin__ = 92;
            validate_non_negative_index("center_mu", "trait", trait);
            validate_non_negative_index("center_mu", "trait", trait);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> center_mu(trait, trait);
            stan::math::initialize(center_mu, DUMMY_VAR__);
            stan::math::fill(center_mu, DUMMY_VAR__);
            current_statement_begin__ = 93;
            validate_non_negative_index("center_mu0", "trait", trait);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> center_mu0(trait);
            stan::math::initialize(center_mu0, DUMMY_VAR__);
            stan::math::fill(center_mu0, DUMMY_VAR__);
            current_statement_begin__ = 94;
            validate_non_negative_index("center_mu1", "trait", trait);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> center_mu1(trait);
            stan::math::initialize(center_mu1, DUMMY_VAR__);
            stan::math::fill(center_mu1, DUMMY_VAR__);
            current_statement_begin__ = 96;
            lp_accum__.add(lognormal_log<propto__>(alpha, ma, va));
            current_statement_begin__ = 97;
            lp_accum__.add(normal_log<propto__>(delta_ng, mdne, vd));
            current_statement_begin__ = 98;
            lp_accum__.add(normal_log<propto__>(delta_nu, mdnu, vd));
            current_statement_begin__ = 99;
            lp_accum__.add(normal_log<propto__>(delta_po, mdpo, vd));
            current_statement_begin__ = 100;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_Omega, 1));
            current_statement_begin__ = 102;
            for (int t = 1; t <= (K - 1); ++t) {
                current_statement_begin__ = 103;
                lp_accum__.add(normal_log<propto__>(get_base1(tau_raw, t, "tau_raw", 1), get_base1(mt, t, "mt", 1), vt));
            }
            current_statement_begin__ = 108;
            for (int j = 1; j <= J; ++j) {
                current_statement_begin__ = 109;
                stan::math::assign(center_mu, multiply(stan::model::rvalue(PC1, stan::model::cons_list(stan::model::index_min_max(((trait * j) - (trait - 1)), (trait * j)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "PC1"), lambda));
                current_statement_begin__ = 110;
                stan::math::assign(center_mu0, stan::model::rvalue(center_mu, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "center_mu"));
                current_statement_begin__ = 111;
                stan::math::assign(center_mu1, to_vector(center_mu0));
                current_statement_begin__ = 112;
                lp_accum__.add(multi_normal_cholesky_log<propto__>(get_base1(theta, j, "theta", 1), add(theta_mu, center_mu1), L_Omega));
            }
            current_statement_begin__ = 114;
            lp_accum__.add(normal_log<propto__>(to_vector(lambda), 0, 1));
            current_statement_begin__ = 116;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 118;
                lp_accum__.add(GGUM(get_base1(y, n, "y", 1), get_base1(get_base1(theta, get_base1(JJ, n, "JJ", 1), "theta", 1), get_base1(ind, n, "ind", 1), "theta", 2), get_base1(alpha, get_base1(II, n, "II", 1), "alpha", 1), get_base1(delta, get_base1(II, n, "II", 1), "delta", 1), stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()), "tau"), K, M, pstream__));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("delta_po");
        names__.push_back("delta_ng");
        names__.push_back("delta_nu");
        names__.push_back("tau_raw");
        names__.push_back("theta");
        names__.push_back("L_Omega");
        names__.push_back("lambda");
        names__.push_back("delta1");
        names__.push_back("delta");
        names__.push_back("tau");
        names__.push_back("Cor");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(I);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I_po);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I_ne);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I_nu);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(trait);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(trait);
        dims__.push_back(trait);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(trait);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I_NN);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(trait);
        dims__.push_back(trait);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_UM7withcov_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha = in__.vector_lub_constrain(0, 4, I);
        size_t alpha_j_1_max__ = I;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            vars__.push_back(alpha(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta_po = in__.vector_lub_constrain(0, 5, I_po);
        size_t delta_po_j_1_max__ = I_po;
        for (size_t j_1__ = 0; j_1__ < delta_po_j_1_max__; ++j_1__) {
            vars__.push_back(delta_po(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta_ng = in__.vector_lub_constrain(-(5), 0, I_ne);
        size_t delta_ng_j_1_max__ = I_ne;
        for (size_t j_1__ = 0; j_1__ < delta_ng_j_1_max__; ++j_1__) {
            vars__.push_back(delta_ng(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta_nu = in__.vector_lub_constrain(-(5), 5, I_nu);
        size_t delta_nu_j_1_max__ = I_nu;
        for (size_t j_1__ = 0; j_1__ < delta_nu_j_1_max__; ++j_1__) {
            vars__.push_back(delta_nu(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau_raw = in__.vector_lub_constrain(-(5), 0, (K - 1));
        size_t tau_raw_j_1_max__ = (K - 1);
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            vars__.push_back(tau_raw(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > theta;
        size_t theta_d_0_max__ = J;
        theta.reserve(theta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
            theta.push_back(in__.vector_constrain(trait));
        }
        size_t theta_j_1_max__ = trait;
        size_t theta_k_0_max__ = J;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                vars__.push_back(theta[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> L_Omega = in__.cholesky_factor_corr_constrain(trait);
        size_t L_Omega_j_2_max__ = trait;
        size_t L_Omega_j_1_max__ = trait;
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                vars__.push_back(L_Omega(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> lambda = in__.matrix_constrain(P, trait);
        size_t lambda_j_2_max__ = trait;
        size_t lambda_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                vars__.push_back(lambda(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 71;
            validate_non_negative_index("delta1", "I_NN", I_NN);
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta1(I_NN);
            stan::math::initialize(delta1, DUMMY_VAR__);
            stan::math::fill(delta1, DUMMY_VAR__);
            current_statement_begin__ = 72;
            validate_non_negative_index("delta", "I", I);
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta(I);
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 73;
            validate_non_negative_index("tau", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tau(K);
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 75;
            stan::math::assign(delta1, append_row(delta_ng, delta_nu));
            current_statement_begin__ = 76;
            stan::math::assign(delta, append_row(delta1, delta_po));
            current_statement_begin__ = 80;
            stan::model::assign(tau, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable tau");
            current_statement_begin__ = 83;
            for (int d = 2; d <= K; ++d) {
                current_statement_begin__ = 85;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                            get_base1(tau_raw, (d - 1), "tau_raw", 1), 
                            "assigning variable tau");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t delta1_j_1_max__ = I_NN;
                for (size_t j_1__ = 0; j_1__ < delta1_j_1_max__; ++j_1__) {
                    vars__.push_back(delta1(j_1__));
                }
                size_t delta_j_1_max__ = I;
                for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                    vars__.push_back(delta(j_1__));
                }
                size_t tau_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    vars__.push_back(tau(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 124;
            validate_non_negative_index("Cor", "trait", trait);
            validate_non_negative_index("Cor", "trait", trait);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cor(trait, trait);
            stan::math::initialize(Cor, DUMMY_VAR__);
            stan::math::fill(Cor, DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 127;
            stan::math::assign(Cor, multiply_lower_tri_self_transpose(L_Omega));
            current_statement_begin__ = 129;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 130;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            GGUM(get_base1(y, n, "y", 1), get_base1(get_base1(theta, get_base1(JJ, n, "JJ", 1), "theta", 1), get_base1(ind, n, "ind", 1), "theta", 2), get_base1(alpha, get_base1(II, n, "II", 1), "alpha", 1), get_base1(delta, get_base1(II, n, "II", 1), "delta", 1), stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()), "tau"), K, M, pstream__), 
                            "assigning variable log_lik");
            }
            // validate, write generated quantities
            current_statement_begin__ = 124;
            size_t Cor_j_2_max__ = trait;
            size_t Cor_j_1_max__ = trait;
            for (size_t j_2__ = 0; j_2__ < Cor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cor_j_1_max__; ++j_1__) {
                    vars__.push_back(Cor(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 125;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_UM7withcov";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = I;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_po_j_1_max__ = I_po;
        for (size_t j_1__ = 0; j_1__ < delta_po_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_po" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_ng_j_1_max__ = I_ne;
        for (size_t j_1__ = 0; j_1__ < delta_ng_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_ng" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_nu_j_1_max__ = I_nu;
        for (size_t j_1__ = 0; j_1__ < delta_nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_raw_j_1_max__ = (K - 1);
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_j_1_max__ = trait;
        size_t theta_k_0_max__ = J;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L_Omega_j_2_max__ = trait;
        size_t L_Omega_j_1_max__ = trait;
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_Omega" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_j_2_max__ = trait;
        size_t lambda_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t delta1_j_1_max__ = I_NN;
            for (size_t j_1__ = 0; j_1__ < delta1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t Cor_j_2_max__ = trait;
        size_t Cor_j_1_max__ = trait;
        for (size_t j_2__ = 0; j_2__ < Cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = I;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_po_j_1_max__ = I_po;
        for (size_t j_1__ = 0; j_1__ < delta_po_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_po" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_ng_j_1_max__ = I_ne;
        for (size_t j_1__ = 0; j_1__ < delta_ng_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_ng" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_nu_j_1_max__ = I_nu;
        for (size_t j_1__ = 0; j_1__ < delta_nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_raw_j_1_max__ = (K - 1);
        for (size_t j_1__ = 0; j_1__ < tau_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_j_1_max__ = trait;
        size_t theta_k_0_max__ = J;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L_Omega_j_1_max__ = ((trait * (trait - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_Omega" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_2_max__ = trait;
        size_t lambda_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < lambda_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t delta1_j_1_max__ = I_NN;
            for (size_t j_1__ = 0; j_1__ < delta1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t Cor_j_2_max__ = trait;
        size_t Cor_j_1_max__ = trait;
        for (size_t j_2__ = 0; j_2__ < Cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_UM7withcov_namespace::model_UM7withcov stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
